set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8907778';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0423',
      '40241304',
      '33441033',
      '34231330',
      '20111223',
      '02233104',
      NULL,
      '23034444',
      '33003444',
      '22033101',
      '00211143',
      '24113311',
      '43013422',
      '21011102',
      '40214021',
      '40331123',
      '24401420',
      '11344103',
      '24442324',
      '01134013',
      '14310034',
      '11302431',
      '04320441',
      '01011432',
      '42240423',
      NULL,
      '32001444',
      '33011130',
      '41112431',
      '01342200',
      '32311301',
      NULL,
      '04220321',
      '03441402',
      '44440401',
      NULL,
      '33033444',
      '32422303',
      NULL,
      NULL,
      '41030401',
      '10243403',
      NULL,
      '10404001',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '4302404',
      NULL,
      1.461246,
      NULL,
      NULL,
      '431103',
      2,
      '10-28-2000',
      NULL,
      76.425418,
      NULL,
      NULL,
      14.772051,
      3.054303,
      16,
      79,
      11.300869,
      NULL,
      10,
      9,
      29,
      19.843542,
      19,
      29.761774,
      12.170058,
      6,
      13.523747,
      68.310804,
      NULL,
      62,
      17.047615,
      125.591486,
      8.551618,
      NULL,
      162.013670,
      129,
      NULL,
      NULL,
      284,
      59,
      NULL,
      38.399664,
      33,
      NULL,
      20,
      29.587771,
      225.013955,
      ' 1-25-1991',
      2,
      NULL,
      1,
      3.767090,
      NULL,
      NULL,
      NULL,
      NULL,
      0.980509,
      NULL,
      NULL,
      2,
      1.430586,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-20-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-22-1977',
      48,
      16,
      19,
      NULL,
      18,
      122.532180,
      62,
      106,
      99,
      NULL,
      90.687008,
      NULL,
      ' 0-17-2000',
      26,
      21,
      27,
      101,
      NULL,
      170.287009,
      3,
      ' 7-24-1999',
      NULL,
      27.727862,
      '11- 6-2002',
      7.132926,
      5.617977,
      21,
      7.776566,
      16,
      10.411697,
      NULL,
      7,
      NULL,
      39,
      1,
      0.897001,
      27,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.965031,
      NULL,
      52.853895,
      ' 9-12-1976',
      0,
      106.805454,
      NULL,
      9,
      26,
      20,
      0,
      ' 9- 6-1993',
      2.197384,
      1,
      126.457547,
      ' 3-29-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      6.047040,
      33,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.117836,
      32.794829,
      NULL,
      0,
      45,
      NULL,
      0.084222,
      113,
      0,
      1,
      40,
      NULL,
      28,
      NULL,
      1.133771,
      NULL,
      1.889014,
      0.490504,
      0.226719,
      1.077227,
      NULL,
      1.256801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.405658,
      NULL,
      1.506125,
      0,
      NULL,
      NULL,
      19.358458,
      21,
      NULL,
      NULL,
      29,
      NULL,
      18,
      0,
      1.352278,
      1,
      1,
      0,
      1,
      1.062115,
      NULL,
      NULL,
      ' 5-29-1989',
      ' 3-24-1986',
      NULL,
      ' 4- 8-1974',
      NULL,
      ' 1-27-2000',
      NULL);
commit;
end;
/


