set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9135795';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4341',
      '23401414',
      '04011224',
      '21230431',
      '41342204',
      NULL,
      '02244440',
      '01021031',
      '30140013',
      '42311311',
      '22114313',
      NULL,
      '11230342',
      NULL,
      '44220412',
      '40231442',
      '13213432',
      NULL,
      NULL,
      '12101024',
      '42314323',
      '13403410',
      NULL,
      '13240410',
      '01312000',
      '10331010',
      '24041230',
      NULL,
      '34122013',
      '20032030',
      NULL,
      '31441423',
      '20013024',
      NULL,
      '33030432',
      '10311123',
      '31204001',
      '32000443',
      '13330322',
      '10204101',
      '14130434',
      NULL,
      '43012013',
      '43043102',
      NULL,
      '144',
      '20',
      NULL,
      NULL,
      '0313113',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      ' 0- 8-1999',
      ' 6- 2-1996',
      66,
      NULL,
      41,
      10,
      16.997398,
      NULL,
      54.126738,
      1.809378,
      NULL,
      15,
      3,
      NULL,
      26.144816,
      NULL,
      5.692039,
      3.748482,
      26,
      13.348999,
      NULL,
      11.597982,
      21,
      7.999665,
      77,
      3.014509,
      1,
      NULL,
      237,
      11.308240,
      NULL,
      184,
      173.692441,
      ' 0- 6-1979',
      64,
      39,
      15,
      16,
      205.428167,
      60.626970,
      ' 4-29-2001',
      2.606462,
      NULL,
      NULL,
      NULL,
      1.531189,
      0,
      NULL,
      3,
      1.809411,
      NULL,
      1,
      0,
      1,
      2.112076,
      1.276276,
      1.214720,
      0.413515,
      1.044300,
      0,
      2.637223,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 0-1991',
      55.912732,
      19,
      10,
      12,
      2,
      NULL,
      ' 8-15-1978',
      NULL,
      1.658088,
      269.199892,
      NULL,
      0.531445,
      157,
      1,
      1.932067,
      8,
      NULL,
      NULL,
      NULL,
      '11- 7-1990',
      63.622660,
      40.880490,
      40.737599,
      NULL,
      46.850595,
      87.972699,
      NULL,
      NULL,
      21,
      65,
      5.884476,
      12.077817,
      NULL,
      13,
      6,
      1,
      82.220989,
      NULL,
      177.428471,
      10,
      ' 7- 5-1998',
      26,
      20,
      ' 4-14-1982',
      2,
      24.942565,
      20,
      30,
      28,
      NULL,
      1,
      8,
      1.464083,
      49.967780,
      1.797165,
      1,
      2.540720,
      14,
      0,
      1,
      0,
      1,
      ' 0-29-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      12.586115,
      ' 8- 2-1987',
      NULL,
      NULL,
      NULL,
      32,
      ' 8-22-1977',
      30,
      ' 8- 4-1981',
      3.464897,
      16,
      ' 0-19-1998',
      115.158414,
      50.166975,
      ' 8-20-1987',
      NULL,
      9,
      ' 3-23-1981',
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      ' 1- 7-1984',
      47.005343,
      2,
      1.083168,
      NULL,
      1.674159,
      14.444134,
      ' 6-11-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


