set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8134602';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '2',
      '1',
      '1',
      NULL,
      NULL,
      '2',
      '2',
      '1',
      '2',
      '2',
      '1',
      '0',
      '0',
      NULL,
      NULL,
      '2',
      '3',
      '3',
      '0',
      '4',
      '4',
      '1',
      NULL,
      '4',
      '',
      '1',
      '1',
      NULL,
      '2',
      '3',
      '',
      '',
      '4',
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      '4',
      '1',
      '0',
      '021',
      '43320333',
      9.098368,
      21.627609,
      '4210022',
      1,
      1,
      2,
      NULL,
      NULL,
      1.999255,
      ' 2- 7-1977',
      ' 7-25-1986',
      NULL,
      124,
      2,
      4,
      13.690137,
      17,
      8.025423,
      8,
      23,
      19,
      21.179202,
      NULL,
      10.903161,
      NULL,
      3,
      1.801901,
      11.912299,
      NULL,
      47.038704,
      19,
      NULL,
      16.542965,
      92,
      14,
      1.977598,
      99.763226,
      NULL,
      12.260583,
      182.654088,
      NULL,
      17.263241,
      ' 8- 1-1994',
      52,
      42.968082,
      37.414477,
      15,
      35,
      128.594042,
      ' 0-28-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.489954,
      14.276741,
      21.757969,
      NULL,
      ' 4-24-1977',
      1,
      0,
      NULL,
      1.679214,
      NULL,
      61,
      0.338589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-22-2000',
      11,
      43.227637,
      61,
      54.999479,
      NULL,
      89.409636,
      1.789530,
      25,
      49.367935,
      37,
      43,
      70,
      ' 0- 7-1976',
      3,
      NULL,
      12.633198,
      NULL,
      63,
      59.957475,
      7.327204,
      ' 8- 1-1992',
      NULL,
      18.472416,
      ' 3-28-1985',
      5.001645,
      6.968049,
      5,
      22.941124,
      20,
      8,
      NULL,
      17,
      1,
      7.597170,
      0.566587,
      1.926373,
      4.239733,
      29,
      0,
      2.104811,
      1,
      0.517156,
      ' 6-11-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      208,
      5.839253,
      ' 7-24-1999',
      NULL,
      NULL,
      NULL,
      28,
      ' 2- 1-1990',
      26,
      ' 3-23-2001',
      12.118595,
      3.466766,
      ' 1-23-2003',
      17.661267,
      25.754708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      8,
      ' 3-17-1984',
      35.208184,
      NULL,
      NULL,
      NULL,
      0.472167,
      92.147411,
      ' 0-18-1982',
      NULL,
      13.890332,
      6,
      44.788993,
      NULL,
      10,
      0.677593,
      NULL,
      ' 1- 2-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


