set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8134602';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      '4',
      '4',
      '2',
      '3',
      '3',
      '4',
      '4',
      '2',
      '2',
      '2',
      NULL,
      '4',
      '1',
      '0',
      '4',
      '2',
      '2',
      '0',
      '4',
      '4',
      '2',
      '0',
      '',
      '3',
      NULL,
      '1',
      '3',
      '0',
      '1',
      '2',
      NULL,
      '',
      '1',
      '0',
      NULL,
      '3',
      '1',
      '3',
      NULL,
      '0',
      '0',
      '1',
      '2',
      '243',
      '13114240',
      0.760745,
      8.976747,
      NULL,
      1,
      7,
      NULL,
      NULL,
      NULL,
      0,
      ' 3-28-1979',
      ' 1- 6-2003',
      17.907674,
      285.623881,
      13.615597,
      12.936399,
      27.221364,
      19,
      88.802960,
      15.925082,
      20.528382,
      12,
      11.658209,
      7,
      12,
      27.980255,
      9,
      18,
      9.649284,
      13,
      62,
      24.944748,
      NULL,
      NULL,
      14,
      7.562160,
      NULL,
      67.840907,
      NULL,
      2.772175,
      105.008253,
      34,
      30,
      NULL,
      46.116266,
      31.213916,
      NULL,
      5,
      86.224157,
      NULL,
      ' 4-25-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      9.080059,
      3.965666,
      11,
      2.163425,
      9.974463,
      ' 0-17-1981',
      0,
      0,
      32.150847,
      0,
      NULL,
      NULL,
      NULL,
      3,
      6,
      NULL,
      NULL,
      NULL,
      ' 5-18-1991',
      2,
      NULL,
      NULL,
      74,
      12.442356,
      31,
      63,
      1,
      105,
      78,
      73,
      NULL,
      ' 9- 2-1998',
      0.588569,
      4.453826,
      8,
      19.796706,
      28.720978,
      6.751520,
      NULL,
      ' 4- 7-1988',
      19.459782,
      15,
      NULL,
      3,
      3.310040,
      4,
      17,
      8.985661,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0.895645,
      1.868459,
      NULL,
      19,
      1.627259,
      NULL,
      0,
      1.057690,
      '11-21-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      260.050934,
      36,
      ' 1-24-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-21-1977',
      21,
      NULL,
      8.691320,
      NULL,
      NULL,
      47.168772,
      69.210137,
      '11-21-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      ' 5- 6-2000',
      22.574367,
      22.434593,
      13,
      '10-21-1996',
      3,
      109.550622,
      ' 9-11-1988',
      2,
      57.190000,
      16,
      36,
      '11-29-1984',
      NULL,
      0,
      80,
      '11- 7-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


