set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8134602';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      '0',
      '1',
      NULL,
      NULL,
      '4',
      '4',
      '3',
      '3',
      '2',
      '4',
      '2',
      '1',
      '4',
      '3',
      NULL,
      '0',
      NULL,
      '1',
      '3',
      '0',
      '3',
      '0',
      NULL,
      '0',
      '',
      '0',
      NULL,
      '4',
      '0',
      '2',
      '',
      '',
      '4',
      '2',
      '2',
      '2',
      NULL,
      '0',
      '2',
      '4',
      '4',
      '3',
      '2',
      '040',
      '13322131',
      54.746289,
      29.559209,
      '1403331',
      3,
      71,
      1,
      NULL,
      '222212',
      5,
      ' 8- 7-1998',
      ' 0-23-1997',
      NULL,
      NULL,
      9,
      14,
      6.513032,
      25.882393,
      69.737667,
      NULL,
      23,
      23,
      9,
      6,
      5.615360,
      20.929157,
      2.479797,
      0,
      0.264014,
      17,
      NULL,
      0,
      NULL,
      9,
      21,
      8,
      3,
      37,
      72,
      37.944938,
      135,
      7,
      194.062097,
      ' 6-13-1992',
      3,
      4,
      10,
      23.388852,
      NULL,
      197,
      ' 2-11-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.938244,
      NULL,
      4.935330,
      9.240696,
      NULL,
      NULL,
      NULL,
      1.600828,
      1.305117,
      198.106678,
      1.986114,
      NULL,
      NULL,
      1,
      1.410948,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-13-1988',
      53,
      85,
      10,
      16.712702,
      19.017925,
      NULL,
      36,
      NULL,
      5.825825,
      NULL,
      15.824274,
      77.237967,
      ' 3-16-1988',
      2,
      19,
      9.174177,
      NULL,
      13.697892,
      3.964125,
      9,
      ' 1- 4-1999',
      3.336024,
      2,
      ' 9- 1-1989',
      3.514896,
      NULL,
      8.106622,
      22,
      15,
      8.907697,
      0.886617,
      15.535151,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      26.845996,
      1.258602,
      NULL,
      1.860783,
      1.154995,
      ' 9-19-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      NULL,
      ' 0- 5-1978',
      NULL,
      NULL,
      NULL,
      30,
      ' 2- 8-1986',
      NULL,
      ' 8-24-1997',
      9,
      11,
      ' 6-24-1978',
      6,
      89.775371,
      ' 9-15-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      ' 1- 5-2000',
      NULL,
      9.928926,
      29,
      ' 1-21-1999',
      0.884468,
      68,
      NULL,
      7,
      31.998754,
      1,
      40.083839,
      ' 5-28-1995',
      8.921291,
      0.640663,
      110.967781,
      '11- 5-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


