set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9136650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1043',
      '03330034',
      '34112133',
      '01024213',
      NULL,
      '40014122',
      '14304133',
      '02213013',
      '41414420',
      '30323111',
      '41203344',
      '31214030',
      NULL,
      NULL,
      '34131334',
      '31332024',
      '21042311',
      '33114232',
      '12012014',
      '31220433',
      '34420302',
      NULL,
      '20331213',
      '12012144',
      '13144242',
      '11330044',
      '44003343',
      '10112413',
      '00424011',
      NULL,
      '02214121',
      '20121204',
      NULL,
      '03303440',
      '44343001',
      '23212122',
      '34313404',
      '42203000',
      NULL,
      '22014003',
      '03404001',
      NULL,
      '10141440',
      '40401141',
      '01310212',
      '',
      '',
      NULL,
      NULL,
      '0003322',
      0.300646,
      NULL,
      1,
      NULL,
      '120332',
      3.673920,
      '10-23-1974',
      NULL,
      85,
      NULL,
      27.470892,
      7.040097,
      13,
      9,
      47,
      12,
      14,
      NULL,
      8,
      NULL,
      15.944778,
      NULL,
      7,
      1.933872,
      10,
      NULL,
      51,
      12.212899,
      40,
      14.009465,
      77.458722,
      11,
      NULL,
      73,
      90.479508,
      19.999866,
      38,
      86.244288,
      31,
      '10- 3-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.277330,
      0.074320,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.472672,
      1.748686,
      2,
      1.738659,
      0.525518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67,
      NULL,
      59,
      60.273628,
      61.825649,
      60.824970,
      14,
      45,
      7,
      37.715761,
      5.411412,
      51,
      '10-16-1976',
      12,
      6.415605,
      5.537543,
      NULL,
      15.326905,
      25.691865,
      7,
      ' 3-19-1996',
      NULL,
      0,
      ' 8- 3-1993',
      0,
      17,
      14.316644,
      NULL,
      14,
      10,
      NULL,
      29,
      NULL,
      121.305750,
      0,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-17-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.154721,
      3.536162,
      NULL,
      ' 5- 9-1975',
      1,
      129.645500,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.923785,
      NULL,
      NULL,
      NULL,
      8.785079,
      18,
      8,
      1.986437,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      10,
      0.914340,
      2,
      0.468775,
      0.815036,
      0,
      0.168472,
      NULL,
      ' 9-18-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 3-1976',
      NULL);
commit;
end;
/


