set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9136650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1201',
      NULL,
      '13430332',
      '00314043',
      '34410134',
      '13001133',
      NULL,
      '43334403',
      '04443102',
      '12032322',
      NULL,
      '40040000',
      '10204004',
      '12200401',
      NULL,
      NULL,
      '24314143',
      '00220044',
      '04333424',
      '41210431',
      '03021111',
      '21440444',
      '02044301',
      NULL,
      NULL,
      '23042214',
      '31200441',
      '32401042',
      '44133032',
      '22101300',
      '23310430',
      '34122333',
      '20211012',
      '21032142',
      NULL,
      '14300102',
      '34412234',
      '33101121',
      '33101333',
      '33241310',
      '13201313',
      NULL,
      '24321224',
      NULL,
      '02003413',
      '033',
      '34',
      1,
      2,
      '3030441',
      2.809877,
      19,
      3,
      NULL,
      '404102',
      4.453608,
      ' 1-22-1998',
      ' 7- 6-2003',
      52.848585,
      NULL,
      NULL,
      15.055253,
      22.200661,
      NULL,
      17,
      0.423571,
      4,
      11,
      NULL,
      11,
      NULL,
      3,
      9,
      NULL,
      23,
      4.756769,
      NULL,
      5,
      22,
      16,
      41.797972,
      5,
      0,
      27,
      116,
      76,
      150,
      191.225255,
      157,
      ' 0- 5-1997',
      31,
      45,
      23,
      13.520380,
      91,
      192.972261,
      '11-29-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      75.466056,
      28,
      8,
      12,
      9,
      NULL,
      ' 0- 1-2001',
      NULL,
      0,
      170.789577,
      0.757527,
      1,
      31,
      2,
      NULL,
      37.496680,
      NULL,
      NULL,
      NULL,
      ' 1-20-1979',
      22,
      19.565213,
      NULL,
      25,
      60.285355,
      65,
      17.419045,
      44.063771,
      36.626484,
      57.613344,
      70.075251,
      81,
      ' 7- 3-1990',
      8.246071,
      16.557101,
      16,
      16,
      NULL,
      34,
      8.728135,
      ' 3-24-1989',
      18,
      0,
      ' 7- 6-1976',
      NULL,
      11,
      2.964821,
      6,
      NULL,
      9,
      0,
      13,
      0.821234,
      82,
      1.408415,
      2.603646,
      NULL,
      10,
      NULL,
      NULL,
      1,
      6.849371,
      ' 9-17-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      154.099500,
      0.417486,
      '10- 3-2000',
      NULL,
      NULL,
      NULL,
      3.027320,
      ' 3-10-1998',
      NULL,
      NULL,
      1.284049,
      10,
      NULL,
      20,
      2,
      '10- 7-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 7- 6-1975',
      1.729448,
      18.731763,
      NULL,
      '11-19-1980',
      NULL,
      24,
      ' 1-24-1975',
      5,
      128,
      8.755495,
      57.902999,
      ' 0-26-1994',
      2.380345,
      1,
      270.951292,
      ' 1-10-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


