set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9136650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      '4',
      NULL,
      NULL,
      '2',
      NULL,
      '4',
      NULL,
      '4',
      '2',
      '0',
      '2',
      '2',
      '1',
      NULL,
      '4',
      '2',
      NULL,
      '1',
      '1',
      '0',
      NULL,
      '4',
      '',
      '1',
      '',
      '0',
      '2',
      '1',
      '3',
      NULL,
      '',
      NULL,
      '4',
      '3',
      '1',
      '0',
      '4',
      '0',
      '3',
      '0',
      '1',
      '3',
      '0',
      '440',
      NULL,
      NULL,
      62,
      '2332421',
      2,
      195.593335,
      NULL,
      NULL,
      '233001',
      NULL,
      '10- 7-1988',
      NULL,
      49,
      147,
      0,
      3.579009,
      11.266786,
      0,
      68.297047,
      8,
      15.524001,
      1.201056,
      6.804497,
      1.556175,
      26,
      7,
      29.729334,
      10,
      NULL,
      5.290942,
      39,
      6.191645,
      60.081760,
      7,
      52.913199,
      NULL,
      1,
      64.079234,
      36.099401,
      NULL,
      33,
      45,
      166,
      '11-17-1983',
      9.616931,
      39,
      29,
      3.483029,
      149.028582,
      93.590517,
      ' 3- 4-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      13,
      1,
      ' 7-28-1991',
      0.577422,
      1.712454,
      72,
      0.251022,
      0,
      96.255732,
      NULL,
      1.419682,
      44,
      NULL,
      NULL,
      NULL,
      ' 9- 3-1975',
      2,
      10.525420,
      2.257327,
      53,
      79.537569,
      NULL,
      58,
      NULL,
      NULL,
      6,
      65.984580,
      40.371398,
      '11- 7-1995',
      2,
      3,
      NULL,
      NULL,
      17.344365,
      2.767829,
      7,
      ' 9-24-1995',
      9.990272,
      1.389702,
      ' 2-21-1974',
      10.177787,
      4,
      NULL,
      7,
      NULL,
      2,
      1,
      15.219894,
      0,
      11.607850,
      2,
      1.951133,
      5.950428,
      NULL,
      1.332724,
      NULL,
      0,
      NULL,
      ' 7- 3-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      149,
      10.431658,
      ' 4-23-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-28-1981',
      30.467898,
      ' 0-16-1980',
      NULL,
      12,
      ' 6-19-1980',
      20.025585,
      81,
      '11-25-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      9.845049,
      ' 6-26-1988',
      31,
      5.323022,
      7,
      ' 2-18-1998',
      1.008601,
      113,
      ' 3-17-1988',
      11.637370,
      33.663250,
      NULL,
      76,
      ' 2- 5-1979',
      56,
      NULL,
      NULL,
      ' 4- 1-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


