set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517294';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2033',
      '43440240',
      '11040003',
      NULL,
      '20202243',
      '30120302',
      '32202112',
      '11031222',
      '24134142',
      '34023422',
      NULL,
      '10430343',
      '22242444',
      NULL,
      NULL,
      NULL,
      '00243014',
      NULL,
      '03232310',
      '42332113',
      NULL,
      '03122010',
      NULL,
      '32324140',
      NULL,
      '01244324',
      '30202420',
      NULL,
      '40031132',
      '03313142',
      NULL,
      '22121113',
      '42422411',
      '22321111',
      '42122234',
      NULL,
      '42433343',
      '33434214',
      '04110202',
      '44340423',
      NULL,
      '23433322',
      '30441040',
      '20001432',
      '31202321',
      '420',
      '42',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      '122211',
      1.991445,
      ' 2- 9-1997',
      ' 1-16-1994',
      NULL,
      NULL,
      36.686763,
      18,
      31.605615,
      8,
      17.001150,
      3.055259,
      NULL,
      11,
      18.185035,
      9,
      4,
      12.120468,
      9,
      20,
      2.987972,
      12.817516,
      17.980565,
      NULL,
      NULL,
      27.938535,
      41,
      3,
      1,
      127,
      135.916213,
      81.254451,
      169,
      158.832557,
      NULL,
      ' 3-22-2001',
      1.276803,
      59.784284,
      10,
      30.395919,
      NULL,
      NULL,
      ' 0-24-1997',
      0.731451,
      0,
      1,
      0,
      0.910908,
      3.976355,
      1,
      NULL,
      1.389061,
      1,
      0,
      1,
      0,
      1,
      NULL,
      0.166245,
      1.567613,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 3-1996',
      33,
      4.900642,
      7,
      1,
      7.723347,
      4,
      ' 1- 1-1999',
      1,
      0.226113,
      NULL,
      2.943421,
      3.068658,
      58.798640,
      0,
      NULL,
      93,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      53.565348,
      13,
      6.063787,
      NULL,
      98.128981,
      99,
      84,
      55,
      2.935050,
      NULL,
      81,
      ' 3-23-1981',
      10,
      9.273880,
      6,
      27,
      25,
      55,
      1,
      NULL,
      9,
      0,
      ' 1-17-1975',
      2.814904,
      18.237096,
      20.263317,
      NULL,
      NULL,
      7.608090,
      0.086245,
      12.420714,
      NULL,
      72,
      0.211146,
      3.035248,
      NULL,
      13.037507,
      1.025826,
      0,
      NULL,
      1,
      ' 7- 2-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      43.502177,
      19,
      ' 8- 2-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.120651,
      8.360942,
      ' 5- 5-1980',
      11,
      176,
      '11-17-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      21,
      '11-29-1994',
      71,
      11.804961,
      NULL,
      ' 3- 5-1999',
      1,
      36.466778,
      '11-29-1980',
      17.842573,
      5,
      19.079335,
      16,
      ' 4-12-1976',
      42.928063,
      NULL,
      48,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


