set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9517294';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02341110',
      '41242004',
      '13422304',
      '43123132',
      NULL,
      '40000113',
      '10212424',
      '24131200',
      '00042244',
      '34240211',
      '41112134',
      '21204402',
      '10203441',
      '03013444',
      NULL,
      '22220011',
      '14421322',
      NULL,
      NULL,
      NULL,
      '33014303',
      '41444044',
      '23421203',
      NULL,
      '40232120',
      '33311311',
      '42141023',
      '03143402',
      NULL,
      '31343210',
      '24034214',
      '12231243',
      NULL,
      '42030440',
      NULL,
      '12114420',
      '04301321',
      NULL,
      NULL,
      '41343211',
      '02024243',
      '00441212',
      NULL,
      NULL,
      '022',
      NULL,
      26,
      NULL,
      '2012311',
      1.462324,
      48,
      3,
      NULL,
      '343420',
      NULL,
      ' 9-23-1980',
      NULL,
      128,
      106.396825,
      24,
      9,
      15.660555,
      NULL,
      NULL,
      1.552438,
      27,
      NULL,
      NULL,
      7,
      33,
      NULL,
      2.558464,
      2,
      NULL,
      7,
      14,
      11,
      4.091471,
      11.017949,
      NULL,
      21,
      NULL,
      84,
      NULL,
      66,
      12.117605,
      95,
      NULL,
      ' 5- 6-1975',
      63,
      NULL,
      16.102092,
      NULL,
      22.358876,
      125,
      ' 2-20-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.269551,
      3.651940,
      15,
      3.963124,
      ' 4- 6-1974',
      1,
      1.068630,
      NULL,
      1,
      NULL,
      NULL,
      1.381938,
      0.224699,
      62,
      NULL,
      NULL,
      NULL,
      ' 7-19-1976',
      55,
      101.639414,
      85,
      110,
      62,
      0,
      16,
      46.129593,
      52,
      90.221939,
      121.037424,
      28.450390,
      ' 2-13-2003',
      5,
      NULL,
      15,
      37.000645,
      95.562415,
      153.301843,
      10.424091,
      '10-28-1975',
      5,
      13,
      ' 3-22-1993',
      7.534888,
      3,
      NULL,
      16,
      23.586243,
      6,
      0.018867,
      7.301547,
      1,
      35.285454,
      NULL,
      1.511652,
      9,
      14.190266,
      0,
      0,
      NULL,
      2.026290,
      ' 2-16-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      91,
      28.849500,
      ' 2-12-1988',
      NULL,
      NULL,
      NULL,
      37.061859,
      ' 0-20-1996',
      1.450618,
      ' 2-13-1980',
      NULL,
      1.994330,
      ' 9-11-2000',
      125,
      163,
      ' 7-29-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      18.241197,
      NULL,
      59,
      7,
      20,
      ' 3-13-1991',
      3.017718,
      NULL,
      NULL,
      14.873534,
      11,
      NULL,
      NULL,
      NULL,
      28.646545,
      NULL,
      131.062762,
      ' 9-22-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


