set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9670225';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0410',
      '01431444',
      '34311304',
      '33101230',
      '14144330',
      NULL,
      '04034023',
      '12012203',
      '34430313',
      '22143403',
      '03124344',
      '03014140',
      '11001340',
      '22322042',
      '14214442',
      '13343232',
      NULL,
      '41121421',
      '41203300',
      NULL,
      '10223431',
      NULL,
      '24103421',
      NULL,
      '04100301',
      '13130330',
      '11043112',
      '34000424',
      '34113010',
      NULL,
      '43234140',
      '23442202',
      '23322234',
      NULL,
      NULL,
      '13042431',
      NULL,
      '04401202',
      '04302401',
      '01410413',
      '33403110',
      '02300033',
      '24220002',
      '14304144',
      '01210111',
      '330',
      NULL,
      10,
      7.685020,
      '4314314',
      0.732462,
      1,
      2,
      NULL,
      '144340',
      NULL,
      ' 3- 3-1986',
      NULL,
      NULL,
      80.196669,
      19.240339,
      NULL,
      25.227546,
      15,
      63.317809,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      16.217547,
      4,
      NULL,
      18,
      8,
      NULL,
      1,
      1,
      4.709155,
      NULL,
      37,
      7.424295,
      0,
      53,
      75,
      6.851050,
      154.793790,
      178.864946,
      NULL,
      NULL,
      NULL,
      11,
      27.687452,
      18.926326,
      95,
      34.114554,
      ' 2- 8-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      35.684946,
      15,
      12.346559,
      5.700076,
      NULL,
      0,
      0.071517,
      49.443390,
      NULL,
      1.942181,
      46,
      1.026750,
      NULL,
      66,
      NULL,
      NULL,
      NULL,
      ' 7-23-1997',
      53.494409,
      76,
      NULL,
      NULL,
      60,
      83,
      22,
      63,
      26,
      49,
      NULL,
      28,
      ' 0-21-1988',
      3,
      19,
      4,
      12,
      31.286983,
      NULL,
      NULL,
      ' 4-13-1980',
      24,
      NULL,
      NULL,
      13,
      NULL,
      0,
      NULL,
      10.556481,
      0.987282,
      1,
      2,
      1,
      NULL,
      1,
      15,
      13.093969,
      15,
      NULL,
      NULL,
      2.190676,
      NULL,
      ' 7- 2-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      159,
      11.412779,
      ' 0-19-1987',
      NULL,
      NULL,
      NULL,
      0,
      ' 6-15-1985',
      NULL,
      ' 6- 6-1991',
      15.382085,
      15,
      NULL,
      7,
      NULL,
      ' 1-27-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      17.039988,
      ' 7- 3-1979',
      NULL,
      2,
      11.615114,
      ' 5- 3-1983',
      3.007940,
      NULL,
      ' 3-19-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


