set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9211089';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      '1',
      '4',
      '3',
      '1',
      '4',
      '0',
      '1',
      '4',
      '1',
      '0',
      NULL,
      '0',
      '2',
      '3',
      '1',
      '3',
      '1',
      '4',
      '0',
      '1',
      '4',
      '0',
      '',
      NULL,
      '',
      '4',
      '0',
      '3',
      '4',
      '0',
      '',
      '',
      '2',
      '2',
      '2',
      '4',
      '4',
      '0',
      '1',
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      52,
      '2333041',
      NULL,
      NULL,
      3,
      NULL,
      '310040',
      NULL,
      ' 3- 3-1997',
      ' 1-20-2001',
      268.526762,
      NULL,
      26,
      23.883308,
      27,
      NULL,
      60,
      NULL,
      15,
      6.988782,
      27,
      9.578479,
      35.124180,
      NULL,
      20.620275,
      5,
      21,
      15,
      46,
      10.015328,
      1,
      8,
      NULL,
      9,
      0.286554,
      108.373823,
      145.029359,
      NULL,
      123.409386,
      62.647034,
      155,
      NULL,
      43,
      3,
      35.104856,
      5,
      NULL,
      148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24.346491,
      28.140445,
      9,
      16,
      15.829674,
      0,
      ' 0- 6-1984',
      1.180825,
      0,
      NULL,
      0.586362,
      0,
      78,
      1.767972,
      6,
      38.888589,
      NULL,
      NULL,
      NULL,
      ' 8-22-1981',
      16,
      84,
      98.225353,
      72,
      37,
      NULL,
      58,
      NULL,
      105,
      NULL,
      17.487817,
      56,
      ' 3- 8-1975',
      7.990227,
      8,
      14,
      NULL,
      55,
      88.505762,
      10.591877,
      ' 1-16-1981',
      19,
      1.226725,
      ' 5-13-1990',
      3,
      3.664576,
      7.565700,
      NULL,
      NULL,
      9.223521,
      0,
      NULL,
      1,
      72,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.479035,
      ' 6-12-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      90.324804,
      6.197459,
      '11-15-1981',
      NULL,
      NULL,
      NULL,
      13.747961,
      ' 0- 1-2003',
      NULL,
      ' 5- 2-1975',
      NULL,
      5,
      '10-15-2001',
      NULL,
      NULL,
      ' 1- 0-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      ' 0-21-1975',
      NULL,
      20,
      6.728729,
      ' 4-10-1998',
      0,
      17.427268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


