set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614546';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      '4',
      '2',
      '2',
      '0',
      '3',
      '2',
      '4',
      '2',
      '4',
      '1',
      NULL,
      '2',
      '0',
      '3',
      '3',
      '3',
      NULL,
      '1',
      '2',
      NULL,
      '2',
      NULL,
      '',
      '3',
      '',
      '3',
      '4',
      NULL,
      '1',
      NULL,
      '',
      '',
      '2',
      '4',
      '4',
      NULL,
      '3',
      '3',
      '1',
      '4',
      '3',
      '2',
      NULL,
      '210',
      '22420130',
      35,
      68.227543,
      NULL,
      3.926962,
      0,
      0,
      0,
      '224343',
      3,
      ' 6-10-1988',
      ' 2-23-1975',
      245.486130,
      50,
      3.945204,
      0,
      15.687231,
      22.678831,
      68.992898,
      NULL,
      21,
      NULL,
      19,
      17.788607,
      29,
      16,
      15,
      11.105524,
      4.470114,
      NULL,
      46.885817,
      12.604731,
      3,
      8.778781,
      35,
      10.997021,
      NULL,
      108.454380,
      NULL,
      60.928477,
      111.782021,
      27,
      66.432632,
      ' 1-20-1975',
      43,
      13,
      19.645013,
      19,
      171,
      12.871067,
      ' 0-14-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      80.073153,
      3,
      4,
      10.584842,
      3.008858,
      0.279861,
      ' 9-29-1992',
      NULL,
      NULL,
      213.661277,
      NULL,
      0,
      75,
      4,
      3.860719,
      51.064659,
      NULL,
      NULL,
      NULL,
      NULL,
      94,
      NULL,
      NULL,
      58,
      73.728615,
      8.092513,
      66,
      NULL,
      4.036278,
      47.562062,
      7.624735,
      29,
      ' 2-15-1994',
      8,
      17.139831,
      12,
      0.695883,
      54,
      NULL,
      NULL,
      ' 7-23-1988',
      7.230166,
      12.225633,
      '11- 1-1990',
      12.261072,
      NULL,
      11.925952,
      10,
      22,
      10,
      1,
      16,
      1.814998,
      18.529717,
      2,
      NULL,
      8,
      26,
      0.671925,
      3,
      NULL,
      1,
      ' 7- 4-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      6.840709,
      18,
      ' 6-13-2001',
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      16.438954,
      ' 4-16-1999',
      6,
      12,
      ' 4- 0-1974',
      108,
      43,
      ' 4-17-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      13,
      ' 6-21-1996',
      35,
      17.587080,
      6,
      NULL,
      3.676336,
      71,
      ' 9-11-1991',
      4,
      27.947697,
      14.021543,
      NULL,
      '10-23-1981',
      65.948891,
      NULL,
      NULL,
      ' 3- 9-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


