set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9526255';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4103',
      NULL,
      '23441022',
      '44304030',
      NULL,
      NULL,
      '24013300',
      '21002310',
      '14133313',
      '34443121',
      '24441113',
      '22122024',
      NULL,
      '34331011',
      '44341140',
      NULL,
      '34400334',
      '01100240',
      '30413341',
      '41242101',
      '00222334',
      '31422030',
      '20402441',
      '41220103',
      NULL,
      '01414041',
      NULL,
      '42312314',
      '43142401',
      '32104410',
      NULL,
      NULL,
      NULL,
      '43121134',
      '43201033',
      '14110440',
      '21434011',
      '13413030',
      NULL,
      '20041223',
      '20033123',
      '20140342',
      '23311241',
      '03420042',
      '01220120',
      '314',
      '32',
      NULL,
      NULL,
      '4010421',
      0.514263,
      1,
      0,
      NULL,
      '142211',
      5,
      '10- 2-2002',
      ' 4-18-1998',
      137,
      NULL,
      18,
      4,
      18,
      20,
      NULL,
      0,
      14,
      11,
      24.983110,
      14.053415,
      22,
      10,
      10,
      NULL,
      NULL,
      10.999953,
      25,
      NULL,
      13.843158,
      5.422319,
      20,
      9,
      1.090030,
      98,
      31,
      16,
      16,
      NULL,
      5.155021,
      ' 6-22-1977',
      NULL,
      5.106937,
      NULL,
      11,
      8.166802,
      NULL,
      ' 1- 1-2003',
      0.790640,
      0,
      NULL,
      1.432278,
      1,
      1,
      2.728302,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.170055,
      1,
      0.753305,
      NULL,
      0,
      0,
      1.284372,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-29-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      23.733861,
      NULL,
      2,
      128.857061,
      0.452868,
      1.243997,
      17,
      NULL,
      NULL,
      NULL,
      ' 6-18-1975',
      40,
      44,
      82,
      17,
      72.795885,
      40.739186,
      2,
      65,
      NULL,
      32,
      4.787939,
      NULL,
      ' 9- 8-1993',
      28.782385,
      28.307734,
      14.459933,
      43.108733,
      0,
      38,
      1,
      ' 2-23-1989',
      NULL,
      10,
      '10-11-1997',
      4,
      0.818088,
      10.820562,
      11,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      3.879880,
      0,
      0.428697,
      13.968078,
      20,
      2,
      4,
      3,
      2.008678,
      '11- 3-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-13-1996',
      NULL,
      ' 1-13-2003',
      0,
      3,
      ' 2- 8-1985',
      31.392525,
      NULL,
      ' 7-11-2002',
      0,
      6.178259,
      '11-17-1976',
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      ' 5-29-2003',
      32,
      12,
      8,
      ' 3- 6-1994',
      NULL,
      20,
      ' 1- 4-1977',
      4,
      25.599832,
      0,
      2.732417,
      ' 7-19-1974',
      62.114586,
      0.459647,
      98.105427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


