set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9526255';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12113431',
      '13144321',
      '00342433',
      '10141243',
      '11243232',
      '30320113',
      NULL,
      '44123111',
      '34422434',
      NULL,
      '20044424',
      '12001021',
      NULL,
      NULL,
      '14422231',
      '42043210',
      NULL,
      '20023211',
      NULL,
      '23221240',
      '31241014',
      '41311014',
      '32103403',
      '14012442',
      '04143410',
      '44033223',
      '01442402',
      NULL,
      NULL,
      NULL,
      '42203013',
      NULL,
      NULL,
      '12121040',
      '43402322',
      '04030421',
      NULL,
      '11233041',
      '12043022',
      NULL,
      '34322044',
      NULL,
      '21342321',
      '00344240',
      '304',
      '40',
      30.723031,
      12.080580,
      '1224131',
      2,
      48,
      3,
      NULL,
      '342431',
      1,
      ' 5-26-1985',
      ' 9-15-1998',
      89,
      116,
      1.662817,
      11.070785,
      NULL,
      10,
      39,
      NULL,
      NULL,
      0,
      9.312880,
      14,
      1.095621,
      NULL,
      2,
      2,
      0.838390,
      1.394903,
      18.273927,
      6,
      9,
      1,
      31,
      1.646969,
      1,
      73.062977,
      26.300937,
      NULL,
      152,
      125.018805,
      NULL,
      '11-17-1998',
      29,
      40.785394,
      9,
      25.790031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      25,
      16,
      29,
      4,
      '11-29-1998',
      0.369744,
      1,
      138.959595,
      NULL,
      2,
      105,
      NULL,
      0.341402,
      27,
      NULL,
      NULL,
      NULL,
      '11- 6-1988',
      66,
      16,
      60.562790,
      10,
      NULL,
      20.642530,
      70.899706,
      NULL,
      16.872551,
      20.348553,
      0.412057,
      30.535441,
      ' 1-14-1986',
      NULL,
      1,
      3.252870,
      NULL,
      16.174165,
      27.104135,
      11.419345,
      '10- 1-1985',
      3.339538,
      2,
      ' 6-29-1989',
      1.623313,
      0,
      4.726235,
      0.196522,
      5,
      0.045897,
      0.568659,
      1,
      1.179070,
      27,
      1.647929,
      NULL,
      1.584484,
      10,
      6,
      11,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55.197939,
      NULL,
      ' 8-15-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      '11-22-1982',
      1.476702,
      ' 8-18-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      9,
      '11-25-1999',
      49,
      NULL,
      NULL,
      NULL,
      1,
      137.856688,
      '10- 7-1987',
      NULL,
      NULL,
      5,
      24.026100,
      ' 5- 9-1992',
      42.194678,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


