set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9526255';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      '3',
      '0',
      NULL,
      '4',
      NULL,
      '1',
      '2',
      '3',
      '0',
      '3',
      '2',
      '3',
      '4',
      NULL,
      '2',
      '2',
      '3',
      '3',
      '4',
      '1',
      '3',
      '4',
      '',
      NULL,
      '',
      '1',
      '1',
      '2',
      '4',
      '0',
      '',
      '',
      '3',
      '3',
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '1',
      '3',
      '3',
      '4',
      NULL,
      '33012141',
      44,
      53.046062,
      '1040214',
      3,
      NULL,
      0,
      NULL,
      '411024',
      NULL,
      ' 4-22-1990',
      NULL,
      76.374526,
      147.418247,
      27,
      12.590960,
      17.731686,
      1,
      33,
      11.948751,
      6.160781,
      1,
      NULL,
      10,
      8,
      9,
      14.372274,
      7,
      2,
      8,
      39,
      NULL,
      37.609474,
      NULL,
      47.924607,
      3.707393,
      3.744374,
      90.077979,
      100.984653,
      NULL,
      29.207459,
      85,
      119,
      ' 8-21-1985',
      47,
      12,
      3,
      13.119825,
      NULL,
      152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      12.040331,
      3,
      27,
      3.954268,
      '11- 5-1989',
      NULL,
      NULL,
      89.746502,
      0.711540,
      0,
      1,
      1,
      0.139884,
      13.517630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45,
      7.890562,
      75.622776,
      NULL,
      60.889883,
      32,
      59,
      17,
      52,
      1.157403,
      28.481926,
      ' 1-21-1980',
      16,
      0.037802,
      4,
      19.420390,
      13.447251,
      19.590971,
      6,
      ' 8-17-1996',
      13,
      NULL,
      ' 8-26-1983',
      NULL,
      1.717410,
      NULL,
      5,
      7,
      5.389802,
      NULL,
      3,
      1,
      33,
      0,
      1,
      2.874193,
      6.296976,
      23.130756,
      1,
      NULL,
      0.445381,
      ' 1-29-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27,
      NULL,
      3,
      ' 1-17-1979',
      NULL,
      NULL,
      NULL,
      60,
      81,
      ' 5- 9-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2.350848,
      NULL,
      ' 7-24-1995',
      0.696497,
      5.902510,
      NULL,
      3.365648,
      8,
      NULL,
      17.443771,
      ' 1- 0-1974',
      31.504639,
      0,
      24.236244,
      ' 6- 1-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


