set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9511616';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4013',
      '24031432',
      NULL,
      '31244343',
      '21401214',
      '11302200',
      '41402210',
      '14432430',
      '43143003',
      '11140021',
      '00333400',
      '14133300',
      '10022033',
      '41243412',
      '11210020',
      '32432431',
      NULL,
      '22211342',
      '01424020',
      '30123311',
      '23320434',
      '11112203',
      NULL,
      '14043031',
      '34324140',
      '43110300',
      '12410143',
      '24103341',
      '32432204',
      '40422311',
      '41012441',
      '44022401',
      '13201013',
      NULL,
      NULL,
      '12243122',
      NULL,
      '20010103',
      '04301314',
      '00021443',
      '03341442',
      '42201034',
      '33024201',
      '10124110',
      '04013102',
      '043',
      '30',
      NULL,
      NULL,
      '1100100',
      0,
      NULL,
      2,
      NULL,
      '334443',
      3.812782,
      NULL,
      ' 7- 5-1986',
      87,
      NULL,
      NULL,
      19.073070,
      7.440716,
      6.053881,
      85.631447,
      NULL,
      NULL,
      15.061395,
      27.819230,
      16.220317,
      NULL,
      21,
      15,
      NULL,
      22.275159,
      15.203525,
      67,
      NULL,
      NULL,
      12,
      NULL,
      21.080177,
      1.821157,
      NULL,
      154.065929,
      65.133582,
      172,
      89,
      96.934159,
      ' 0-19-1977',
      NULL,
      13.669471,
      NULL,
      28,
      NULL,
      147.936803,
      ' 8-24-1982',
      2,
      1,
      3,
      NULL,
      0,
      0,
      3,
      1,
      0,
      0.229492,
      0,
      1,
      0,
      1.599193,
      0,
      0.207696,
      1,
      NULL,
      NULL,
      0.724948,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-17-1985',
      65,
      8.478071,
      5.068257,
      16.869885,
      11,
      1,
      ' 2-26-1990',
      3.997117,
      NULL,
      44.016046,
      1.382872,
      3,
      29,
      1.630660,
      1.290748,
      76.947103,
      NULL,
      NULL,
      NULL,
      NULL,
      51.136170,
      20.473012,
      52,
      42,
      37,
      36,
      NULL,
      74.319371,
      65,
      15.791784,
      26.830055,
      55,
      '10- 4-1993',
      NULL,
      NULL,
      21,
      32.687760,
      56.998819,
      61,
      7.946070,
      NULL,
      22.833683,
      NULL,
      ' 1-21-1985',
      13,
      19.337483,
      10.258716,
      0.959736,
      19,
      3.760745,
      NULL,
      29.394787,
      0,
      NULL,
      0.306895,
      6.107702,
      7.544057,
      29,
      2,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      132,
      NULL,
      '11-28-1986',
      NULL,
      NULL,
      NULL,
      48.914414,
      ' 0-21-1977',
      NULL,
      ' 4-23-1975',
      19,
      13.451359,
      '11-15-2001',
      37,
      39,
      ' 9-12-1991',
      1,
      3,
      '10-26-1980',
      NULL,
      NULL,
      NULL,
      2,
      3,
      10,
      '11-28-1983',
      30.351534,
      35.536287,
      21.661067,
      ' 1- 2-1978',
      NULL,
      56.190673,
      ' 0- 8-1975',
      17.441403,
      79.889421,
      19,
      23.379098,
      ' 0-23-1996',
      29.095812,
      NULL,
      NULL,
      ' 2- 5-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


