set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5601823';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4003',
      '40242200',
      '22343044',
      NULL,
      '21320231',
      '11222340',
      '11230442',
      '33432201',
      '32414024',
      NULL,
      '42222422',
      '41324313',
      '22204214',
      '11433002',
      NULL,
      '32300122',
      '30304232',
      NULL,
      '22413402',
      '01232023',
      '23344204',
      '11103344',
      NULL,
      '10034141',
      '21323013',
      NULL,
      '34234304',
      '12302220',
      '34101231',
      '33413230',
      NULL,
      '11312332',
      NULL,
      '11302201',
      '01404110',
      NULL,
      '34412042',
      '03223324',
      NULL,
      '44343202',
      '30442323',
      '21002422',
      '01110121',
      '01420012',
      '12132004',
      '',
      NULL,
      NULL,
      NULL,
      '2204442',
      1.824984,
      1,
      NULL,
      NULL,
      NULL,
      1,
      ' 3- 0-1989',
      ' 5-15-1992',
      51,
      NULL,
      27.140752,
      NULL,
      36,
      7.170283,
      80,
      0.181306,
      20,
      23,
      27,
      12,
      15,
      NULL,
      16,
      5.465623,
      23.579715,
      3.606051,
      9,
      19,
      31,
      1.255378,
      NULL,
      7,
      NULL,
      29,
      179,
      32.230042,
      60.885118,
      9.184620,
      91.736084,
      ' 9-27-1998',
      NULL,
      38.723260,
      NULL,
      33.371096,
      183,
      NULL,
      ' 2- 4-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-26-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      19,
      NULL,
      31,
      40,
      2,
      ' 6- 1-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      23.828254,
      NULL,
      '11- 6-1976',
      NULL,
      128,
      ' 5- 9-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20.067311,
      14,
      14,
      0,
      2,
      NULL,
      9.821847,
      25,
      2,
      1,
      89.484509,
      0.080484,
      0.243176,
      83,
      1.683245,
      1.852213,
      55,
      0.338473,
      2,
      148,
      13,
      NULL,
      NULL,
      0.418095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      73.831491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      16.880055,
      0.528759,
      61,
      NULL,
      NULL,
      NULL,
      5.142282,
      9,
      1.907699,
      NULL,
      2,
      0.322223,
      NULL,
      NULL,
      7,
      ' 3-12-1989',
      NULL,
      NULL,
      NULL,
      ' 3- 8-1986',
      NULL,
      '10- 0-1985',
      NULL);
commit;
end;
/


