set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9129684';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0123',
      '30433423',
      NULL,
      '21142133',
      '33330223',
      '02421224',
      '43312204',
      '04110134',
      '31034002',
      '30241141',
      '41341430',
      '31124021',
      '21234421',
      NULL,
      '43040334',
      '14433102',
      '12244421',
      '10140432',
      '22114304',
      '02321342',
      NULL,
      '22441301',
      '44241020',
      '31243100',
      '13201014',
      '20034143',
      NULL,
      '13123211',
      '20141241',
      NULL,
      '12003444',
      NULL,
      '42204431',
      '10414422',
      '03221143',
      '03003034',
      NULL,
      '40011241',
      '02013034',
      NULL,
      '14241004',
      NULL,
      '23330303',
      '31334333',
      '23211404',
      NULL,
      '20',
      NULL,
      NULL,
      '4414141',
      NULL,
      0.993483,
      NULL,
      NULL,
      '112220',
      2.546490,
      '10-27-1976',
      ' 0-29-1983',
      55.700824,
      NULL,
      35.280084,
      15.811854,
      18.206922,
      8.522657,
      23,
      NULL,
      NULL,
      9.737811,
      44.451026,
      11,
      6,
      11,
      2,
      4.692095,
      NULL,
      NULL,
      13,
      10,
      13,
      3.926910,
      8,
      NULL,
      1.772768,
      NULL,
      97,
      48.148146,
      152.824246,
      156.462858,
      40,
      '10-24-1980',
      11.339156,
      19,
      4,
      NULL,
      76,
      NULL,
      ' 6-19-1974',
      1.893848,
      NULL,
      0.264861,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      1.634374,
      1.184740,
      0,
      NULL,
      0.268783,
      0,
      1.874611,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 7-1989',
      68,
      1,
      2,
      NULL,
      3,
      NULL,
      '10-29-2003',
      1.963272,
      1,
      NULL,
      1.243433,
      0,
      97.140092,
      1.365325,
      0,
      13,
      NULL,
      NULL,
      167.780533,
      ' 1-12-1993',
      71.435974,
      NULL,
      15.745160,
      70.952515,
      79.403265,
      80.903617,
      NULL,
      73,
      33,
      1,
      69.982146,
      32,
      ' 0-18-1984',
      2.058177,
      21,
      4.608085,
      NULL,
      NULL,
      NULL,
      9.675461,
      ' 7-16-1979',
      9,
      16,
      ' 5- 2-1998',
      4.637330,
      17.674824,
      1.758462,
      NULL,
      22.877550,
      0.464613,
      0.313306,
      6,
      0.351902,
      NULL,
      NULL,
      1.393390,
      11,
      31,
      1,
      3,
      0,
      1.818985,
      ' 3-18-1974',
      2.826842,
      0,
      3.549665,
      ' 1-18-1980',
      106,
      9,
      NULL,
      18.983762,
      0.365195,
      NULL,
      53.932360,
      ' 9- 3-1996',
      21,
      ' 4-10-1991',
      9.850442,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      10.589820,
      17.284842,
      ' 3-19-1987',
      3,
      7,
      ' 1-15-1984',
      2,
      2,
      0.936789,
      NULL,
      63,
      15,
      7.875163,
      ' 3-24-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.236271);
commit;
end;
/


