set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8724508';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '00434124',
      '44321230',
      '32032232',
      '04311414',
      NULL,
      '23321340',
      NULL,
      '03213224',
      '24124203',
      NULL,
      '42343323',
      NULL,
      '20333241',
      '04304020',
      '12320314',
      NULL,
      NULL,
      NULL,
      '13201002',
      NULL,
      NULL,
      NULL,
      '43323222',
      '14123142',
      NULL,
      '40033441',
      '23404203',
      '02120233',
      NULL,
      '02400200',
      '43240243',
      NULL,
      '03113241',
      '10423410',
      '03021320',
      NULL,
      '31031421',
      NULL,
      '40220424',
      '42414442',
      '04311010',
      '41241130',
      '20240440',
      NULL,
      '',
      NULL,
      NULL,
      '0440313',
      1.336834,
      1,
      2,
      NULL,
      '043142',
      2,
      ' 5-29-1999',
      NULL,
      8.280611,
      NULL,
      4.841009,
      10.111837,
      6.487448,
      13,
      30,
      4.512848,
      11,
      NULL,
      10,
      10.080890,
      3.040322,
      7.719795,
      0.205611,
      NULL,
      1,
      2,
      15,
      10.590852,
      9,
      3.646814,
      3,
      7,
      NULL,
      81.257053,
      93.866221,
      32,
      NULL,
      53.204539,
      NULL,
      '10-21-1987',
      34,
      0,
      23.143062,
      NULL,
      56.705401,
      94,
      '10-15-1993',
      2,
      NULL,
      2.548137,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.975137,
      1.933407,
      1,
      NULL,
      3.152974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-11-1982',
      8.104875,
      74.121436,
      30.707536,
      70,
      2.082949,
      NULL,
      72.324833,
      NULL,
      67.597966,
      NULL,
      10.712509,
      71,
      ' 2-13-1974',
      13.205752,
      21.192917,
      1,
      46,
      NULL,
      5,
      6.184927,
      ' 3- 6-1977',
      5,
      NULL,
      ' 3- 9-1985',
      2.659528,
      2,
      NULL,
      NULL,
      5,
      2.553003,
      NULL,
      5.863270,
      NULL,
      0,
      0.010622,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-18-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.802587,
      4.500344,
      ' 0-25-1988',
      1.281301,
      126,
      NULL,
      4,
      279,
      2.411619,
      34.713317,
      NULL,
      NULL,
      0,
      54,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      14.582127,
      78.191530,
      58.932218,
      181.375991,
      109,
      2.186948,
      52.900757,
      NULL,
      NULL,
      3,
      2,
      21,
      0,
      NULL,
      NULL,
      0,
      0.569636,
      303,
      2,
      4.066056,
      164,
      22.229510,
      18,
      52,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1.656887,
      NULL,
      NULL,
      83.772966,
      NULL,
      NULL,
      21,
      15.728749,
      62,
      9.606821,
      0.416782,
      19,
      NULL,
      NULL,
      1.507838,
      NULL,
      0,
      NULL,
      1,
      18,
      1,
      1,
      4,
      18,
      NULL,
      22.241265,
      35.897800,
      39,
      4.326083,
      58,
      6.242655,
      NULL,
      2,
      12,
      2.436757,
      NULL,
      1,
      0,
      10,
      ' 0-28-1993',
      ' 1- 7-1976',
      ' 3-25-1975',
      ' 6- 2-1985',
      NULL,
      ' 7-19-1981',
      ' 6- 6-1975',
      NULL);
commit;
end;
/


