set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0100555';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      '4',
      '0',
      '3',
      '1',
      '0',
      NULL,
      '3',
      '3',
      '2',
      NULL,
      NULL,
      '0',
      '0',
      '0',
      NULL,
      '3',
      NULL,
      '3',
      '0',
      '3',
      '1',
      NULL,
      '0',
      '',
      '4',
      '4',
      NULL,
      '0',
      '0',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      '1',
      '4',
      '0',
      '3',
      '3',
      '230',
      NULL,
      NULL,
      NULL,
      '1021420',
      1,
      1,
      3,
      1,
      '442223',
      NULL,
      NULL,
      '10-13-1989',
      14,
      NULL,
      22.483922,
      0.846269,
      5.184400,
      0,
      47.398762,
      0,
      11,
      1.518904,
      NULL,
      3,
      15.518137,
      0.021840,
      20.330697,
      12,
      20,
      2.495530,
      95,
      4.045240,
      45,
      24,
      90.111017,
      24,
      1.789024,
      24,
      180,
      109,
      116,
      129,
      198,
      ' 0-21-1989',
      22,
      25.886186,
      25.015726,
      NULL,
      12.666896,
      161.576823,
      ' 1-16-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      5,
      0.135887,
      4.987138,
      3,
      4,
      NULL,
      0.047078,
      0,
      103,
      NULL,
      0,
      99.937048,
      NULL,
      1,
      27.122365,
      NULL,
      NULL,
      NULL,
      ' 1- 4-1995',
      13.819439,
      NULL,
      67,
      42,
      NULL,
      29.039799,
      23,
      48.769837,
      90,
      NULL,
      NULL,
      89,
      '11-27-1996',
      30,
      NULL,
      21.917669,
      26.167065,
      29.160773,
      50.323174,
      10.373540,
      ' 4-19-1989',
      14.128204,
      2,
      ' 5-12-1995',
      7,
      10.259154,
      NULL,
      10.153785,
      12.561965,
      NULL,
      NULL,
      NULL,
      0.483841,
      NULL,
      2,
      0.033558,
      NULL,
      16.116680,
      4,
      NULL,
      2,
      1.438505,
      ' 8- 7-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      55,
      3.662626,
      ' 0- 9-2000',
      NULL,
      NULL,
      NULL,
      53,
      ' 0- 6-1974',
      40.657538,
      ' 4-19-1982',
      8,
      2.464349,
      '11- 5-1986',
      146.438324,
      NULL,
      ' 2-15-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      15,
      '10-21-1999',
      49,
      30,
      7,
      ' 8-29-1996',
      0,
      NULL,
      '10-21-1974',
      15.605106,
      22.342718,
      NULL,
      24,
      ' 3- 9-1993',
      9.116010,
      1.348049,
      74.397715,
      ' 1- 3-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


