set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027300';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3032',
      '22343233',
      '44411223',
      '23023042',
      '03200214',
      '33020320',
      '01310043',
      '44101321',
      '11211031',
      '14301022',
      NULL,
      '30400221',
      '03333213',
      NULL,
      '34003440',
      '32230421',
      '43013342',
      NULL,
      NULL,
      '22411013',
      NULL,
      '21412204',
      '33220103',
      '40201024',
      NULL,
      '22432311',
      '02412412',
      NULL,
      '21413400',
      '02244314',
      '04004343',
      NULL,
      '40113302',
      '42434422',
      '11244112',
      '00144243',
      '34031332',
      '40422111',
      NULL,
      '41113131',
      '31040332',
      '03042324',
      NULL,
      '33303333',
      '43004311',
      '223',
      '43',
      0.460071,
      NULL,
      '0142431',
      3,
      1.339945,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-26-1981',
      ' 4- 3-1997',
      18.044781,
      24.477287,
      34.198673,
      10,
      3,
      0,
      90,
      16.391539,
      27.596273,
      5,
      35.608241,
      NULL,
      NULL,
      2.692028,
      0.542658,
      6,
      8,
      14,
      NULL,
      10,
      29,
      1.854914,
      NULL,
      NULL,
      1,
      136,
      214,
      59.050722,
      38,
      NULL,
      NULL,
      ' 1-23-2003',
      30.764808,
      6.097218,
      37.250040,
      30,
      11,
      39.421426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      8,
      NULL,
      9,
      ' 9- 2-1977',
      0,
      5.176860,
      NULL,
      0.289990,
      NULL,
      70.076462,
      NULL,
      1.231271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      NULL,
      62.051807,
      65,
      70,
      6,
      84,
      78,
      11.561573,
      51.884722,
      8,
      51,
      ' 7-24-1979',
      20.116254,
      NULL,
      0,
      75.135829,
      43.444618,
      54.509149,
      4.236833,
      '10-25-1990',
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3,
      12,
      13.615972,
      10.294945,
      1,
      15.505688,
      0,
      58.559749,
      3.318721,
      1.547987,
      13,
      12,
      5.394178,
      5.893950,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 4-1977',
      NULL,
      NULL,
      NULL,
      42.898990,
      ' 7- 5-1988',
      NULL,
      ' 0-17-1981',
      10,
      2,
      ' 6- 1-1984',
      NULL,
      49.195430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      19,
      ' 3- 6-2000',
      54.026338,
      NULL,
      44,
      ' 9-10-1979',
      0,
      50,
      '11-12-1976',
      10.898802,
      19,
      11.142124,
      0,
      ' 4- 2-1992',
      31,
      0,
      NULL,
      ' 4- 3-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


