set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027300';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '2',
      NULL,
      '1',
      '4',
      NULL,
      '1',
      NULL,
      NULL,
      '0',
      NULL,
      '3',
      '4',
      '1',
      NULL,
      '2',
      '4',
      '4',
      '2',
      '0',
      '4',
      '2',
      '0',
      '',
      '1',
      '',
      '1',
      NULL,
      NULL,
      NULL,
      '1',
      '',
      NULL,
      NULL,
      '3',
      '1',
      '2',
      '0',
      '0',
      '3',
      '3',
      '0',
      '0',
      '2',
      '321',
      '23424200',
      NULL,
      NULL,
      '1231012',
      NULL,
      6.491082,
      2,
      NULL,
      '123214',
      3,
      ' 9- 5-2003',
      '10-27-1974',
      NULL,
      73.724628,
      NULL,
      16.455206,
      NULL,
      4.813241,
      110,
      4,
      NULL,
      9.869131,
      29.797162,
      11.913016,
      32.466886,
      14.101290,
      9.146484,
      7.385373,
      28,
      NULL,
      60.215408,
      17,
      26,
      4.775708,
      75,
      NULL,
      1.478636,
      119,
      113.424130,
      68.057478,
      167,
      NULL,
      92,
      NULL,
      24.273752,
      1,
      22,
      28.352697,
      151,
      NULL,
      ' 2-17-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      105,
      2.462447,
      6,
      1.192124,
      8.739300,
      7,
      '10-25-1980',
      0,
      2.562002,
      219,
      1.461395,
      0,
      22.447403,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-13-1976',
      20.979360,
      53.149297,
      48.175081,
      56,
      NULL,
      46.217861,
      29.636263,
      38,
      19,
      60,
      1.040776,
      78.297435,
      '11- 9-1997',
      18,
      NULL,
      NULL,
      63.716839,
      22,
      60.261726,
      9,
      '11-19-1999',
      18,
      18,
      ' 7- 3-1981',
      7.354151,
      9.809234,
      8.830114,
      22.481992,
      5.488825,
      8,
      1,
      NULL,
      1.135437,
      NULL,
      3,
      0,
      17.906768,
      5.115279,
      1.929039,
      1.356373,
      1,
      0.452931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      192,
      1.986066,
      ' 8-24-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      '10-29-1978',
      45,
      NULL,
      14.223729,
      NULL,
      ' 2-23-1979',
      110,
      20,
      ' 3-18-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      28,
      NULL,
      27,
      NULL,
      1.659953,
      ' 4-16-1988',
      0.948549,
      15,
      NULL,
      3,
      14,
      2,
      25,
      ' 7-14-1978',
      59.619207,
      1.797193,
      116,
      ' 7-27-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


