set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027300';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '4',
      NULL,
      '2',
      '3',
      '3',
      '3',
      '3',
      '4',
      '0',
      '1',
      NULL,
      NULL,
      '0',
      '1',
      '2',
      '0',
      '3',
      '0',
      '4',
      NULL,
      '3',
      NULL,
      '',
      '2',
      NULL,
      '4',
      '2',
      '1',
      '2',
      '0',
      '',
      NULL,
      '1',
      '1',
      NULL,
      '0',
      '4',
      NULL,
      '3',
      '2',
      '0',
      '3',
      '4',
      '220',
      '12231001',
      64,
      41,
      '3303340',
      2,
      111.314483,
      1,
      0,
      '311431',
      1,
      ' 1-29-1980',
      NULL,
      158,
      95,
      2.418181,
      9.654431,
      13,
      NULL,
      33.787999,
      18,
      25.910243,
      8.559690,
      38,
      NULL,
      45,
      17,
      16.832342,
      NULL,
      7,
      8,
      70,
      3,
      63,
      4,
      3.116442,
      9.215857,
      1,
      40.155826,
      51.829109,
      83,
      NULL,
      236,
      35,
      ' 2- 0-2001',
      4.059849,
      NULL,
      NULL,
      NULL,
      26,
      NULL,
      '10-16-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      85,
      7.965766,
      3,
      5,
      NULL,
      7,
      ' 8-13-1987',
      1.037387,
      2.779051,
      119,
      1.854177,
      0.394290,
      93,
      0.678821,
      1.938116,
      58.231411,
      NULL,
      NULL,
      NULL,
      ' 3-20-2001',
      83,
      NULL,
      34,
      5,
      NULL,
      NULL,
      NULL,
      76,
      42,
      66.549552,
      NULL,
      29,
      ' 4-17-2003',
      22.430272,
      9,
      4.212085,
      NULL,
      28,
      NULL,
      NULL,
      ' 2-18-1986',
      NULL,
      13.204441,
      ' 2- 5-2003',
      8.638578,
      17.252031,
      21,
      2.144471,
      4,
      2.644705,
      0,
      17.869535,
      1.076184,
      27,
      1.726071,
      2.467094,
      0.077682,
      2,
      1.524131,
      0.099935,
      0,
      1,
      ' 9-26-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      239.134669,
      1.365973,
      ' 2-10-1980',
      NULL,
      NULL,
      NULL,
      31.884012,
      NULL,
      3.448662,
      ' 6-15-1988',
      3.154630,
      10.873647,
      ' 4-10-1999',
      156.113912,
      99.396303,
      ' 6- 3-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      11.187916,
      NULL,
      51,
      21,
      21,
      ' 0-20-1975',
      0,
      74,
      NULL,
      2,
      16.352007,
      5.512475,
      49.195374,
      ' 2-11-1994',
      66,
      0.853754,
      102,
      ' 4- 5-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


