set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9118214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2341',
      NULL,
      '44424423',
      '13013420',
      '42242020',
      '11313302',
      '13104321',
      '01003442',
      '40323212',
      '00003421',
      '24214124',
      '13441330',
      '42032034',
      '34332410',
      '30203220',
      NULL,
      '03310002',
      '33241112',
      '24132424',
      NULL,
      '33312243',
      '14341210',
      '22030013',
      '20220220',
      '43101100',
      '20233344',
      '44110320',
      '30304313',
      NULL,
      '30442434',
      '11110324',
      '31424033',
      '22401231',
      '13222232',
      NULL,
      '03321003',
      '01042030',
      '23204121',
      NULL,
      '43324204',
      NULL,
      '41230041',
      '34141240',
      '11103043',
      '44021224',
      NULL,
      NULL,
      NULL,
      NULL,
      '3430341',
      1.194570,
      0,
      3,
      NULL,
      NULL,
      NULL,
      ' 7- 3-1978',
      ' 1- 4-1978',
      23.227929,
      NULL,
      37.040689,
      24,
      32,
      1.345397,
      15.222697,
      6,
      13,
      4,
      54,
      13,
      12,
      12,
      27,
      NULL,
      13.592742,
      0,
      5.535223,
      8,
      53.640687,
      11.394498,
      75,
      5,
      NULL,
      NULL,
      112.581152,
      95,
      176.705087,
      16,
      209,
      ' 7-24-1995',
      20,
      38.838393,
      36,
      18,
      109.961359,
      15.526593,
      ' 2-27-1997',
      1,
      0.699888,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.776060,
      0,
      1.978804,
      1.112033,
      NULL,
      0,
      0,
      NULL,
      1.302281,
      1.687538,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 7-1974',
      NULL,
      1,
      7,
      0,
      3.075354,
      9.164963,
      '11-13-2002',
      1.714217,
      2.971297,
      76,
      0,
      1.764783,
      101,
      0.413499,
      1,
      27.943691,
      1.952903,
      3.671989,
      75.447325,
      ' 0- 7-1984',
      75.614523,
      0,
      62.379027,
      NULL,
      105.413416,
      107,
      13.626262,
      0,
      NULL,
      12.068664,
      53,
      109,
      NULL,
      NULL,
      15,
      11,
      29,
      28.981332,
      110.778013,
      2,
      ' 3- 8-1998',
      7.557458,
      0.756253,
      ' 8- 1-1980',
      NULL,
      7,
      13.546644,
      18,
      NULL,
      16.736838,
      0.380150,
      0.725311,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.944700,
      3,
      NULL,
      0,
      ' 7-15-1988',
      0.135072,
      NULL,
      3.572206,
      ' 6- 9-1976',
      124,
      0,
      ' 0-28-1997',
      64.840994,
      1.227021,
      '11-15-2002',
      5,
      ' 1- 0-1994',
      NULL,
      ' 3-24-1989',
      11.641263,
      12.924668,
      ' 0-10-1978',
      63,
      NULL,
      ' 7-26-1976',
      NULL,
      NULL,
      NULL,
      0,
      2.924787,
      ' 0-25-1995',
      1,
      0,
      6.623885,
      ' 0-26-1977',
      21.170180,
      3.880756,
      3.440169,
      ' 1- 8-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.084135);
commit;
end;
/


