set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829512';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4034',
      '33012444',
      '40304112',
      '02234424',
      '40412231',
      NULL,
      '44332444',
      '43121231',
      '00343112',
      '23440022',
      '44010332',
      '22232310',
      NULL,
      '42421110',
      '01244140',
      '33230410',
      '12330231',
      '10031323',
      '32213034',
      '43344431',
      '33401420',
      NULL,
      NULL,
      NULL,
      '43204101',
      '30422423',
      '42213020',
      '02241421',
      NULL,
      '11410402',
      '12111210',
      NULL,
      '22333444',
      '30233123',
      NULL,
      '01210001',
      '40031411',
      '42224232',
      '32323112',
      '31040441',
      '43020402',
      '34041410',
      '42442140',
      '00100321',
      '01411144',
      '001',
      '32',
      19.182628,
      8,
      '3040223',
      1.239391,
      1.722579,
      0,
      NULL,
      NULL,
      0,
      ' 7-14-1987',
      NULL,
      41.642320,
      NULL,
      19.712485,
      13.667367,
      30,
      5.331202,
      NULL,
      NULL,
      11.580627,
      15,
      7,
      9,
      39,
      6.734598,
      NULL,
      0,
      15.110383,
      16,
      24.254111,
      16.359772,
      2,
      13.511817,
      25.453300,
      17,
      0.276733,
      41.904776,
      1.663273,
      63.747632,
      NULL,
      147.000338,
      NULL,
      NULL,
      NULL,
      27,
      13,
      16.527453,
      134,
      195.270156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      47.184790,
      NULL,
      35.667181,
      12,
      1,
      NULL,
      0,
      0.718402,
      22.418640,
      0,
      0,
      39.523877,
      1.780629,
      1.962515,
      76,
      NULL,
      NULL,
      NULL,
      ' 0-28-1991',
      NULL,
      33,
      58.715533,
      61,
      NULL,
      61.016558,
      1.241308,
      41,
      4,
      27,
      NULL,
      89.903096,
      NULL,
      18,
      13,
      9.108229,
      15,
      25,
      140,
      8,
      ' 6-24-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 6-20-2003',
      NULL,
      NULL,
      NULL,
      0.136791,
      ' 7-17-2000',
      40,
      NULL,
      NULL,
      6.935824,
      '10- 7-1984',
      NULL,
      58,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      '11-24-1988',
      0.105280,
      44,
      16.313038,
      '11-25-1991',
      4.716372,
      91.270043,
      ' 8-20-1974',
      7,
      41.151593,
      2,
      25.125182,
      ' 6- 7-1990',
      25.982228,
      0,
      53,
      ' 6- 2-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


