set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829512';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33430214',
      '41022131',
      '44101034',
      NULL,
      NULL,
      '00022032',
      '03232140',
      '33213031',
      '34104433',
      '32421200',
      '43122132',
      '30410223',
      '22214010',
      NULL,
      '02241322',
      '10432310',
      NULL,
      NULL,
      NULL,
      '02230113',
      '20340314',
      '14330140',
      '13112244',
      '23111234',
      '12434111',
      '31321400',
      '42001204',
      '00202442',
      '12203104',
      NULL,
      '24333011',
      NULL,
      NULL,
      '11420011',
      '03331244',
      '14121120',
      '44103023',
      '03442230',
      NULL,
      '41440103',
      '10103211',
      '11244000',
      NULL,
      '23102234',
      '431',
      '44',
      6.587465,
      24.527923,
      '1144443',
      0.428125,
      32.863532,
      2,
      NULL,
      '000132',
      4,
      NULL,
      ' 9-22-1978',
      NULL,
      37.923417,
      11.235471,
      11.206962,
      1,
      18,
      11.977621,
      3.844613,
      5,
      18,
      37,
      11,
      16.183626,
      NULL,
      15.802314,
      7.249867,
      8,
      4.031342,
      13,
      27.875647,
      48,
      24.370227,
      73,
      2,
      0,
      28,
      10.480226,
      NULL,
      157,
      1.008069,
      NULL,
      ' 8-27-1991',
      NULL,
      4,
      22.232866,
      3.647360,
      66.032464,
      164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      82.449772,
      40.440202,
      12.443011,
      26.659015,
      NULL,
      0.394871,
      NULL,
      0,
      NULL,
      4.073840,
      NULL,
      0,
      76,
      1,
      2.689853,
      46,
      NULL,
      NULL,
      NULL,
      ' 8-18-1983',
      46.933329,
      3.563620,
      11,
      1.690780,
      NULL,
      NULL,
      NULL,
      79.070491,
      NULL,
      32.924545,
      102,
      55.295914,
      ' 4-27-1986',
      8.466442,
      25.402438,
      11.704537,
      NULL,
      79,
      102,
      9,
      '11- 8-1994',
      0,
      NULL,
      '11-19-1979',
      5.685473,
      4.237722,
      0.359160,
      7,
      NULL,
      2.118563,
      1,
      0.027399,
      0.965348,
      57.665545,
      0.866185,
      0,
      2,
      27.991776,
      1.723398,
      0.567916,
      2.897937,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      81.873652,
      NULL,
      ' 7- 2-2000',
      NULL,
      NULL,
      NULL,
      34.785527,
      ' 5- 3-1994',
      NULL,
      ' 2-12-1992',
      NULL,
      3.257409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      21,
      NULL,
      67.916950,
      34.628568,
      27.871141,
      ' 0- 0-1981',
      NULL,
      122,
      ' 5- 7-1993',
      NULL,
      70.962058,
      11,
      18.248887,
      ' 5-19-1988',
      NULL,
      NULL,
      NULL,
      ' 9- 4-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


