set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659883';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10234411',
      '22013423',
      '41202013',
      '32204021',
      '11311404',
      '22342400',
      '34300423',
      '12213242',
      '14423330',
      '00203101',
      '32123034',
      '04410303',
      '00114402',
      NULL,
      '42123321',
      '14102402',
      '30323200',
      '22110104',
      '24404133',
      '13231101',
      '12143214',
      '33414421',
      '41141433',
      '43044223',
      '02134140',
      '44240424',
      '32442111',
      '44302320',
      '40303104',
      '14144333',
      NULL,
      '03102101',
      '31011120',
      '03434302',
      NULL,
      '14413311',
      '33332110',
      '12302102',
      '22224033',
      '31143014',
      '11030130',
      '31222140',
      '22244034',
      '00022314',
      NULL,
      '44',
      20.433252,
      NULL,
      '0230301',
      2.387876,
      1,
      2,
      NULL,
      '211030',
      3.971228,
      NULL,
      '11- 2-1974',
      122,
      39.572216,
      18,
      4.779627,
      13,
      19,
      53.659210,
      NULL,
      NULL,
      NULL,
      22,
      1,
      3.814858,
      17.433765,
      19.415305,
      3.299623,
      7,
      NULL,
      14.936120,
      NULL,
      51,
      17.874145,
      109,
      23,
      1.735780,
      78.253725,
      129.866306,
      1.970811,
      NULL,
      71,
      108,
      NULL,
      24.798550,
      34,
      17.265744,
      0,
      234,
      216.988230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      9,
      8.302503,
      8,
      NULL,
      2.016095,
      0.449834,
      27.995526,
      0,
      1.193406,
      137.964502,
      1.266729,
      4,
      64,
      NULL,
      NULL,
      NULL,
      ' 6- 1-1981',
      NULL,
      90.735172,
      NULL,
      35,
      48.098469,
      4.824476,
      37,
      100.961181,
      44,
      85.233051,
      35.616255,
      48,
      ' 4- 9-1975',
      12.793809,
      13.917049,
      21,
      0.978944,
      13,
      69.968531,
      6,
      ' 9- 6-2000',
      6,
      7,
      '10-18-1975',
      9.753968,
      13.016108,
      NULL,
      27.462765,
      5.347759,
      13,
      NULL,
      8,
      0,
      82.501834,
      0.026140,
      1,
      12.260851,
      NULL,
      1,
      0,
      0.081650,
      0.621446,
      ' 3- 2-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      13.731807,
      17,
      ' 3-13-1995',
      NULL,
      NULL,
      NULL,
      4.031992,
      '11- 2-1974',
      4.060559,
      ' 0-15-1981',
      6,
      19.433404,
      ' 8-29-1977',
      111,
      10.384231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.167787,
      ' 8-14-1977',
      64.450647,
      NULL,
      16.411906,
      ' 0-20-1986',
      0.363244,
      66.930635,
      ' 8-16-1999',
      11.252858,
      118,
      19,
      21,
      ' 1- 0-1981',
      NULL,
      NULL,
      60.337950,
      ' 6-29-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


