set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659883';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      '3',
      '2',
      NULL,
      '1',
      '3',
      '1',
      NULL,
      '2',
      '1',
      '0',
      NULL,
      '3',
      '4',
      '4',
      '3',
      '1',
      '1',
      '1',
      '0',
      '',
      '3',
      '',
      '3',
      NULL,
      NULL,
      '3',
      NULL,
      '',
      '',
      '0',
      NULL,
      NULL,
      '3',
      '2',
      '0',
      '0',
      '0',
      '4',
      '3',
      '3',
      NULL,
      '21',
      NULL,
      35.219431,
      '3121414',
      3.145551,
      38.202151,
      3,
      NULL,
      '112031',
      5,
      NULL,
      ' 2- 6-1978',
      77,
      219.900181,
      15.941129,
      NULL,
      17.878283,
      17,
      57.528088,
      1,
      17,
      2.095320,
      12.705124,
      8,
      11.163589,
      7.507531,
      27.530586,
      1,
      7,
      NULL,
      14,
      7.109817,
      51,
      17.266143,
      40,
      2.591232,
      1,
      75,
      144.776959,
      59,
      61.302309,
      166,
      NULL,
      ' 0- 9-1998',
      5,
      43,
      8.341076,
      13,
      129.582531,
      183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61,
      12,
      4,
      1,
      9,
      1,
      ' 4-28-2000',
      NULL,
      1.453061,
      214.182324,
      1,
      0.257704,
      NULL,
      1,
      NULL,
      96.564951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      130.409414,
      118,
      64.646725,
      25.359537,
      55.574420,
      112,
      95.215047,
      22,
      71,
      5,
      ' 0-28-1993',
      6.388168,
      26.539730,
      23,
      NULL,
      54,
      88,
      6.450030,
      NULL,
      28.222453,
      4.575953,
      ' 4-25-1979',
      9,
      15.986495,
      4,
      5,
      17,
      9,
      1,
      10,
      1,
      17,
      1.592159,
      0,
      9.776466,
      6.938098,
      1,
      1.976131,
      1.702085,
      1.155637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      8.992278,
      ' 4-11-1976',
      NULL,
      NULL,
      NULL,
      7.234440,
      ' 6-23-1994',
      2,
      ' 6-16-1995',
      0,
      NULL,
      ' 0- 7-1974',
      27.060072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 7-18-1996',
      24.592014,
      NULL,
      47.593427,
      ' 0-11-1979',
      2.746178,
      NULL,
      NULL,
      2,
      9,
      5,
      NULL,
      ' 9-26-1984',
      62,
      0,
      77.527840,
      '11-22-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


