set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9037500';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      '1',
      '2',
      NULL,
      '0',
      '3',
      '0',
      '0',
      '2',
      '1',
      '4',
      '0',
      '1',
      '0',
      '4',
      NULL,
      '4',
      '4',
      '0',
      '2',
      NULL,
      '1',
      '0',
      '',
      '2',
      '',
      '1',
      '4',
      '0',
      '4',
      '3',
      '',
      '',
      '1',
      '3',
      '4',
      '4',
      NULL,
      '1',
      '1',
      '1',
      '0',
      '3',
      '0',
      '113',
      '42143343',
      27.941476,
      5,
      '2143413',
      3,
      1.196682,
      0,
      NULL,
      '414414',
      5,
      ' 5-28-1977',
      ' 2- 3-1989',
      29,
      69,
      38.369467,
      1,
      NULL,
      14.096142,
      62,
      14.335608,
      6,
      15,
      28.826137,
      NULL,
      NULL,
      15,
      29,
      2,
      28,
      7.755964,
      NULL,
      14.653367,
      42,
      7,
      80.773556,
      17,
      0.984967,
      51,
      117,
      70,
      155.114045,
      148.800987,
      NULL,
      '11-27-1988',
      14,
      28.728679,
      13.498230,
      31.871921,
      10.594995,
      197,
      ' 0- 1-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      69,
      20,
      15,
      18.287182,
      NULL,
      3,
      '10- 6-1991',
      0.686813,
      NULL,
      116.771516,
      NULL,
      NULL,
      NULL,
      1.326820,
      1,
      5,
      NULL,
      NULL,
      NULL,
      ' 1-23-2002',
      66.450884,
      18.943108,
      10,
      31.445744,
      81,
      51.410020,
      29.626838,
      79,
      6,
      6,
      90.304421,
      84,
      ' 0-15-2000',
      5,
      NULL,
      9.931598,
      NULL,
      4,
      71,
      11.736876,
      ' 1-19-1975',
      11.767930,
      7.474353,
      NULL,
      4,
      NULL,
      9.934540,
      NULL,
      6,
      2.949085,
      1,
      NULL,
      1,
      NULL,
      0,
      0.958047,
      8.677777,
      1.591691,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40.639763,
      8.023675,
      ' 1-10-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-27-1979',
      5,
      NULL,
      NULL,
      13.173272,
      ' 1- 7-1980',
      81.878026,
      33.356104,
      ' 2- 2-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      ' 9-27-1998',
      54.654571,
      10,
      12.435232,
      ' 2- 6-2001',
      0,
      46.918320,
      '10-10-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


