set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7716787';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3021',
      '13102420',
      '04143123',
      '40100032',
      '03414413',
      '10432223',
      '34211410',
      '11241111',
      '42134101',
      '10421000',
      '01440344',
      '31121234',
      '31240401',
      '13402241',
      '43123304',
      '22342124',
      '10432010',
      '22243142',
      '20113320',
      NULL,
      NULL,
      '21214432',
      '11133002',
      '13210411',
      '02114424',
      '22010120',
      '23343023',
      NULL,
      '00323212',
      '31110004',
      '44144404',
      '30032421',
      '10422043',
      '13001132',
      '21113334',
      '44011332',
      '32221002',
      '11133010',
      NULL,
      '40222140',
      NULL,
      '43002432',
      '41024302',
      NULL,
      '13111140',
      '402',
      '33',
      18.074395,
      19,
      '0434234',
      1,
      0,
      1,
      NULL,
      '313120',
      1.562538,
      ' 6-21-1998',
      ' 4- 3-1987',
      36,
      24,
      4,
      6.711495,
      3.553737,
      NULL,
      39.888651,
      3,
      13,
      3.274381,
      NULL,
      NULL,
      35.862875,
      7,
      NULL,
      22,
      2,
      NULL,
      NULL,
      NULL,
      59.105867,
      10,
      15,
      NULL,
      0.924158,
      NULL,
      44,
      79.299619,
      9.467634,
      72,
      60,
      ' 2-22-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47.277947,
      60.448174,
      NULL,
      5.443446,
      8,
      3,
      ' 7-29-1995',
      1,
      0,
      57.319125,
      3.566834,
      0,
      NULL,
      0,
      NULL,
      27,
      NULL,
      NULL,
      NULL,
      ' 8- 2-1980',
      8.462876,
      68.291901,
      NULL,
      NULL,
      NULL,
      107,
      20,
      73,
      63.058779,
      53,
      44.029901,
      33,
      ' 7- 5-1979',
      NULL,
      1,
      NULL,
      21.135769,
      44,
      6,
      9,
      '11- 7-1993',
      0,
      3.047497,
      ' 1-14-1980',
      NULL,
      0.234384,
      6,
      3.707579,
      10.723532,
      2.104419,
      0.862978,
      NULL,
      1.623951,
      16,
      1,
      3.395752,
      0,
      NULL,
      11.312856,
      4,
      NULL,
      1.247392,
      ' 5- 4-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46.675715,
      ' 5- 0-1999',
      21.550801,
      ' 5-15-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      19,
      ' 9-17-1987',
      5,
      26,
      33.903462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      6,
      53,
      ' 5-22-1990',
      NULL,
      NULL,
      137,
      ' 4- 5-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


