set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9526331';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      '0',
      '3',
      '1',
      '1',
      NULL,
      '2',
      '0',
      NULL,
      '2',
      NULL,
      '0',
      NULL,
      '2',
      NULL,
      '2',
      '2',
      '3',
      '3',
      '3',
      '1',
      '1',
      '',
      NULL,
      NULL,
      '4',
      '2',
      '2',
      '2',
      '4',
      '',
      '',
      '3',
      NULL,
      '0',
      '2',
      '4',
      '3',
      '3',
      '1',
      '3',
      '2',
      '1',
      '133',
      '30113224',
      NULL,
      NULL,
      '1410020',
      1,
      1,
      NULL,
      NULL,
      '414104',
      NULL,
      ' 8- 2-1983',
      ' 2-20-1989',
      8.072577,
      239,
      19,
      11,
      37,
      NULL,
      16.824335,
      8,
      2,
      5,
      18.000093,
      14.508836,
      32,
      21.016614,
      37,
      20.762677,
      1.327707,
      18.239716,
      81.219829,
      0,
      55,
      16,
      141,
      20,
      1,
      135.465485,
      74.272932,
      26.702628,
      110.592268,
      90,
      4,
      ' 2-12-1985',
      NULL,
      7,
      24.623103,
      27,
      186.167585,
      NULL,
      ' 7-10-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.012061,
      7,
      6,
      0.600169,
      NULL,
      0,
      ' 1- 7-1979',
      NULL,
      0,
      138,
      NULL,
      NULL,
      NULL,
      1,
      1,
      39.146708,
      NULL,
      NULL,
      NULL,
      ' 6- 2-1992',
      89.728405,
      95,
      NULL,
      105,
      NULL,
      NULL,
      64,
      NULL,
      NULL,
      74.917034,
      42,
      54,
      ' 8-24-1997',
      3,
      23,
      3.232198,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      25.498591,
      NULL,
      '10- 5-1995',
      19.576620,
      NULL,
      2.266670,
      15.669446,
      17.842393,
      4,
      0.951818,
      12.120028,
      0.918130,
      NULL,
      NULL,
      0,
      8.490193,
      5.860628,
      1,
      NULL,
      1.994456,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      55.268594,
      ' 4-14-1992',
      24,
      '11-13-2000',
      10.430017,
      NULL,
      ' 3-21-1986',
      NULL,
      23.947652,
      ' 7-29-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.569750,
      ' 3-28-1995',
      48.930868,
      NULL,
      25,
      ' 8-24-1997',
      NULL,
      29.677672,
      ' 8- 9-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


