set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9677077';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      '0',
      '4',
      '3',
      '0',
      '0',
      '2',
      '4',
      '1',
      '0',
      NULL,
      '1',
      '0',
      '3',
      '0',
      '0',
      '1',
      '4',
      '3',
      NULL,
      '3',
      '1',
      '0',
      '',
      NULL,
      '',
      '1',
      '0',
      '0',
      '0',
      '3',
      '',
      '',
      '2',
      '4',
      '2',
      '2',
      '4',
      NULL,
      '0',
      NULL,
      '1',
      '3',
      '1',
      '130',
      '21101212',
      42.351256,
      0,
      '2014434',
      0.676496,
      0,
      0,
      NULL,
      '100333',
      4.576399,
      NULL,
      ' 4- 9-1976',
      NULL,
      16.450404,
      31,
      11,
      11,
      28.285708,
      66,
      24,
      30.280890,
      4.314983,
      25.027399,
      NULL,
      35,
      0.712477,
      18,
      15.265982,
      8,
      3.246070,
      54,
      12,
      4.606747,
      1,
      NULL,
      11,
      0.705839,
      27,
      NULL,
      41.431385,
      153,
      178.221716,
      198.530294,
      ' 1- 8-1996',
      39.132019,
      3.038603,
      9.961807,
      35,
      178.446488,
      215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      68.574493,
      43.441804,
      21.892669,
      40.653229,
      NULL,
      ' 8-22-1999',
      0.781183,
      1.158827,
      94.250414,
      0,
      0.957432,
      14,
      2.053747,
      1.991685,
      27,
      NULL,
      NULL,
      NULL,
      ' 4-21-1986',
      NULL,
      NULL,
      9.008317,
      NULL,
      9,
      23,
      25,
      70,
      81,
      10.822290,
      63,
      1.929198,
      ' 5-23-1994',
      NULL,
      8.606355,
      NULL,
      18.444272,
      19,
      NULL,
      4,
      '11-22-1987',
      15.953487,
      11.662289,
      ' 9- 2-1992',
      11,
      7,
      17,
      23,
      17.481744,
      2.112534,
      0.992675,
      11,
      0,
      115,
      0.513098,
      6.895844,
      19,
      21.191660,
      2,
      5.112190,
      NULL,
      0,
      ' 2- 6-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      182.546815,
      3.628651,
      ' 8-10-1990',
      NULL,
      NULL,
      NULL,
      15,
      ' 0- 7-1998',
      31,
      NULL,
      5.168438,
      2.759471,
      ' 3-18-1983',
      23,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      ' 6- 3-1985',
      7,
      18,
      8.669160,
      NULL,
      0,
      NULL,
      ' 6-21-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


