set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9305828';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3220',
      NULL,
      '03344102',
      NULL,
      NULL,
      NULL,
      '34134324',
      NULL,
      '04204203',
      '21332403',
      '10100400',
      '24421020',
      '11433344',
      '34221400',
      '02044021',
      '22022241',
      '30322203',
      '31343343',
      '23243010',
      NULL,
      '24341233',
      '31324441',
      NULL,
      '03122233',
      '23002334',
      '03201240',
      NULL,
      '30403002',
      '03012004',
      '04423042',
      '24243240',
      '41120402',
      '40132403',
      '13304433',
      '31020311',
      '40202120',
      '44021024',
      '32420243',
      '04314110',
      '11343412',
      NULL,
      '02222023',
      '04444142',
      '14420102',
      '33220311',
      '422',
      '00',
      NULL,
      NULL,
      NULL,
      NULL,
      1.602289,
      2,
      NULL,
      '241221',
      0.235556,
      ' 1- 2-1975',
      ' 8- 5-1997',
      2.122253,
      NULL,
      20.775101,
      NULL,
      23.126840,
      12,
      NULL,
      NULL,
      21.866788,
      16.719583,
      0.747728,
      16.394303,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      21.599704,
      26,
      NULL,
      69,
      6,
      NULL,
      83,
      108.914957,
      81.260228,
      81.698465,
      36.247350,
      166.807055,
      ' 4-20-1993',
      32,
      17,
      8,
      0.076559,
      76,
      108.893823,
      ' 7-17-2003',
      NULL,
      0,
      0.089591,
      1.332808,
      1,
      1.104216,
      1,
      NULL,
      0.744150,
      0,
      0,
      0.350469,
      NULL,
      0.545059,
      0.642960,
      1,
      0.906508,
      0.920174,
      1.135983,
      0.079210,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 1-1998',
      23,
      5.880796,
      4.936878,
      7.736569,
      26.117238,
      3,
      ' 1- 8-1987',
      0.108990,
      1,
      73,
      5,
      0,
      NULL,
      1,
      0.113898,
      18.442021,
      NULL,
      NULL,
      NULL,
      ' 3- 7-1989',
      98.308933,
      91.262694,
      92.587673,
      94,
      NULL,
      91,
      76.399138,
      37.732610,
      69.114991,
      14.977727,
      61.239525,
      NULL,
      NULL,
      NULL,
      15.537195,
      6.986818,
      92,
      99.920198,
      102,
      0,
      ' 4-14-2003',
      18,
      3,
      '10- 7-1989',
      2.890473,
      19.653885,
      23.902992,
      24,
      19,
      11.372238,
      0,
      NULL,
      1,
      119.784113,
      3,
      1,
      NULL,
      NULL,
      0.063932,
      1,
      1,
      0,
      ' 7- 4-1988',
      0.541686,
      5,
      NULL,
      ' 7- 0-1990',
      107.325899,
      3,
      ' 6-25-1982',
      20.988310,
      1,
      '10-22-1983',
      48.721707,
      ' 7-10-2000',
      49,
      ' 3- 2-2003',
      0.696190,
      9.611554,
      ' 2-17-1990',
      NULL,
      71.401408,
      ' 1-29-1981',
      8.391818,
      3.064053,
      '10-14-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      21,
      ' 3- 3-1975',
      63.933520,
      37.101112,
      53.772436,
      ' 7-29-1982',
      2.609659,
      77,
      ' 5-10-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.835598);
commit;
end;
/


