set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3373783';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      '0',
      '0',
      '4',
      '1',
      '2',
      NULL,
      '2',
      '1',
      '3',
      '0',
      '4',
      '3',
      '4',
      '3',
      '2',
      '1',
      '3',
      '4',
      '2',
      '4',
      NULL,
      '3',
      '',
      '2',
      '',
      '1',
      '0',
      '3',
      '0',
      NULL,
      '',
      '',
      '2',
      '4',
      NULL,
      '1',
      '4',
      '4',
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      '344',
      '02144441',
      NULL,
      40,
      '3221422',
      1,
      0.776476,
      0,
      NULL,
      '143001',
      2.605026,
      ' 9-28-1981',
      ' 2- 2-1976',
      4.910538,
      79,
      12.985892,
      2,
      NULL,
      25,
      29.315524,
      13,
      13.163776,
      3,
      28.334378,
      3.924162,
      NULL,
      19.543576,
      6,
      4.723395,
      NULL,
      17,
      28,
      NULL,
      55,
      13,
      18.187735,
      5,
      0.142497,
      100,
      147,
      41.323100,
      145.402182,
      80.338154,
      26.109267,
      '10-20-1990',
      36,
      3,
      22,
      7.520635,
      59.456785,
      42,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.897106,
      2.980200,
      2.746815,
      2,
      11.947041,
      ' 8-21-1986',
      0,
      NULL,
      186,
      0,
      NULL,
      54.182609,
      0,
      2,
      64.302436,
      NULL,
      NULL,
      NULL,
      ' 4-14-1992',
      63,
      11.237280,
      11.016654,
      53.610345,
      28,
      NULL,
      59,
      52,
      29.056595,
      79.929714,
      19,
      53,
      ' 7-22-2001',
      12.046963,
      8.831938,
      2,
      36.709569,
      32.488337,
      33,
      10,
      NULL,
      NULL,
      4,
      ' 7- 3-1978',
      4.869065,
      NULL,
      3,
      20,
      12.761323,
      NULL,
      0,
      NULL,
      0.843929,
      135,
      1,
      NULL,
      17.713658,
      2,
      0.364613,
      1.886582,
      0.678594,
      0.625255,
      '10-18-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.293720,
      NULL,
      NULL,
      ' 7- 9-1988',
      18,
      16,
      ' 2- 1-1981',
      NULL,
      68.389190,
      ' 5-11-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.526692,
      ' 7- 2-1998',
      NULL,
      NULL,
      6,
      NULL,
      1.237988,
      NULL,
      ' 5-22-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


