set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9209180';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34000041',
      '41443144',
      '20314423',
      NULL,
      '02210013',
      '32034344',
      '40324302',
      '32113233',
      '30441422',
      '33114004',
      '03320003',
      NULL,
      '20304414',
      '32311411',
      '21234300',
      '42041442',
      NULL,
      '30214041',
      '02144420',
      '02414134',
      '44233024',
      NULL,
      NULL,
      '33310324',
      '02232123',
      '23022404',
      '33020343',
      NULL,
      NULL,
      NULL,
      '01220321',
      '20300143',
      NULL,
      '44003231',
      '41142320',
      NULL,
      '43012043',
      '34333131',
      '21440242',
      '43332143',
      '10210103',
      '03424104',
      '44033431',
      '22301422',
      NULL,
      '14',
      NULL,
      NULL,
      '3013333',
      2,
      0,
      1,
      NULL,
      '300012',
      5.397355,
      NULL,
      ' 1-29-1991',
      84.363059,
      NULL,
      32,
      18,
      1.441111,
      NULL,
      66,
      NULL,
      2,
      16.795783,
      28.213984,
      1.243200,
      3,
      17,
      20,
      NULL,
      NULL,
      NULL,
      60.757308,
      16,
      NULL,
      0,
      NULL,
      NULL,
      0.315434,
      103,
      NULL,
      NULL,
      NULL,
      75.597982,
      134.544497,
      NULL,
      3,
      15,
      40,
      29.394352,
      90.310766,
      32.530383,
      ' 7-24-1986',
      0.448543,
      3.562484,
      0.093952,
      3,
      1,
      2,
      NULL,
      5,
      NULL,
      1,
      3,
      0,
      1,
      NULL,
      0.031459,
      1,
      2.838762,
      3,
      NULL,
      6.383530,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-15-1988',
      11,
      16.750599,
      NULL,
      7,
      6,
      0.663277,
      ' 8-24-1975',
      1,
      1,
      NULL,
      0.146550,
      1.105015,
      87,
      1,
      1,
      38,
      1.517160,
      1,
      200.210694,
      ' 6-21-1976',
      13,
      28,
      80,
      62,
      24,
      7,
      NULL,
      NULL,
      12,
      55,
      2.235114,
      26,
      ' 5-20-1992',
      37,
      22.457616,
      18.399843,
      NULL,
      73,
      157,
      10,
      ' 3-25-2003',
      26,
      4.420253,
      ' 6-20-1992',
      16.902389,
      NULL,
      9.411148,
      10.780831,
      17.097593,
      NULL,
      NULL,
      11.156247,
      NULL,
      127.427655,
      0,
      5.087753,
      20,
      18,
      3.519362,
      NULL,
      2,
      1,
      ' 3-26-1981',
      11.480194,
      1,
      4.987763,
      NULL,
      20.206073,
      1,
      ' 3-28-1984',
      NULL,
      NULL,
      NULL,
      41.365947,
      ' 6- 9-1976',
      10,
      NULL,
      11,
      4,
      ' 2-28-1982',
      81,
      97.234020,
      '11- 0-1985',
      0.242473,
      8.627185,
      ' 2-24-1976',
      3,
      7,
      ' 6-24-1990',
      1,
      0,
      NULL,
      NULL,
      25.992454,
      29.340151,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.521026);
commit;
end;
/


