set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9307628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23202423',
      '13213213',
      NULL,
      NULL,
      '44304440',
      '20010013',
      '30424100',
      '31310311',
      '12200013',
      '33004413',
      '03130032',
      '32322404',
      '10213144',
      '24301304',
      '34120421',
      '03414103',
      '42121340',
      '03421113',
      '00432021',
      NULL,
      NULL,
      '13223233',
      '01242123',
      NULL,
      '11441422',
      '11331143',
      '33231022',
      '40110344',
      '44341020',
      NULL,
      NULL,
      '22430210',
      '24122130',
      NULL,
      '03323243',
      NULL,
      NULL,
      '30123224',
      '04404444',
      '12432114',
      '04334324',
      NULL,
      '20040021',
      NULL,
      '301',
      '23',
      NULL,
      NULL,
      '4342004',
      3.022902,
      NULL,
      1,
      NULL,
      '130044',
      5,
      ' 3- 3-1990',
      ' 7-14-1996',
      142.634025,
      NULL,
      NULL,
      19,
      25,
      6,
      68.964270,
      1,
      NULL,
      NULL,
      1,
      5,
      NULL,
      21.769704,
      34,
      4,
      41,
      NULL,
      68,
      NULL,
      29.052730,
      NULL,
      NULL,
      12.630245,
      0.644446,
      2.465416,
      NULL,
      79.728977,
      105,
      93.525112,
      NULL,
      ' 8-25-2000',
      26,
      53,
      6,
      NULL,
      NULL,
      172.313114,
      '11-21-1986',
      0,
      3.193912,
      2.562067,
      1,
      5,
      3.921112,
      NULL,
      0.769102,
      1,
      1,
      0.244253,
      1.917895,
      0,
      0.975687,
      1.109754,
      1.096268,
      0.555337,
      0,
      NULL,
      0.246683,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-16-1985',
      22,
      26.500332,
      5.158180,
      8.078373,
      7.713875,
      NULL,
      NULL,
      0.655880,
      NULL,
      208.680359,
      0.411990,
      0.207910,
      NULL,
      0,
      1.225959,
      11,
      NULL,
      NULL,
      NULL,
      ' 8-13-1979',
      59.515281,
      NULL,
      46,
      69,
      76.131641,
      57.861237,
      49.090451,
      64,
      5.861596,
      11.998780,
      NULL,
      39,
      '10-27-1998',
      14,
      28,
      27,
      72,
      50.556815,
      150.905898,
      3.422317,
      NULL,
      35.937208,
      19,
      ' 5-29-1977',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      1.024731,
      8,
      0,
      71,
      1.273217,
      3,
      7,
      NULL,
      7,
      0,
      NULL,
      3.792029,
      NULL,
      1.732589,
      7.151762,
      NULL,
      ' 8-19-1978',
      110,
      0.304383,
      '10- 1-1996',
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      NULL,
      ' 6- 6-2003',
      0.473010,
      NULL,
      NULL,
      56,
      116,
      ' 6- 5-1981',
      8,
      6.857425,
      '10-20-1990',
      NULL,
      NULL,
      NULL,
      2,
      0,
      18,
      ' 5- 3-1984',
      63.806533,
      13,
      13,
      ' 9- 3-1999',
      NULL,
      78,
      ' 1- 6-1992',
      9,
      27.861874,
      20.691487,
      34.348328,
      ' 1-21-1998',
      14.807378,
      NULL,
      21.462979,
      ' 7-23-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


