set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9307628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10014314',
      '41104021',
      '01223214',
      '24013441',
      '04130423',
      '13432233',
      '03140212',
      NULL,
      '24141442',
      NULL,
      '00140241',
      '21302423',
      NULL,
      NULL,
      '01001200',
      '20130013',
      '22234411',
      NULL,
      '23310120',
      '10011131',
      '12200112',
      '01111441',
      '13010321',
      '31222303',
      NULL,
      NULL,
      '14202222',
      '02034113',
      '11213424',
      '22123210',
      '11233414',
      '22343312',
      '34211323',
      '13233423',
      '42434411',
      '43242302',
      '01403001',
      '41300444',
      '40444431',
      NULL,
      '40404311',
      '24342233',
      '14104022',
      NULL,
      '234',
      NULL,
      0,
      0,
      '2243403',
      3.186922,
      43,
      NULL,
      NULL,
      '434140',
      2.468562,
      ' 1-17-1981',
      NULL,
      NULL,
      NULL,
      37.201327,
      8,
      17.333161,
      5.037571,
      28.802645,
      NULL,
      15.779361,
      18,
      16,
      11,
      NULL,
      4,
      6.229114,
      13.468479,
      10.021055,
      0,
      7.097399,
      NULL,
      38.870221,
      18,
      31.042334,
      14.259587,
      0.522753,
      120,
      NULL,
      78,
      76,
      104.775776,
      70,
      '10- 3-1987',
      56.653009,
      46,
      20,
      8.658784,
      147,
      NULL,
      ' 8-22-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      5.137779,
      6.129164,
      4.152900,
      11.370138,
      6,
      ' 9- 6-1986',
      0,
      1.294691,
      134.891160,
      0.333991,
      NULL,
      96.023843,
      NULL,
      0.730740,
      9,
      NULL,
      NULL,
      NULL,
      ' 0- 2-1987',
      33,
      57,
      11.921871,
      NULL,
      NULL,
      47,
      40,
      35.255829,
      68,
      18.767706,
      19.899499,
      31.831387,
      ' 9- 5-1985',
      23,
      NULL,
      NULL,
      48.735292,
      48,
      10.386789,
      NULL,
      ' 9- 7-1990',
      31,
      8,
      ' 0-20-1995',
      4,
      10,
      7.563776,
      2,
      12,
      1.415067,
      1.337475,
      6,
      1,
      11,
      0,
      3,
      NULL,
      12.862012,
      3.201856,
      0.001760,
      NULL,
      1.050149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      202,
      3.602214,
      ' 9-12-1994',
      NULL,
      NULL,
      NULL,
      31,
      ' 7- 7-2000',
      31,
      '10-20-1983',
      4.392640,
      11.898370,
      NULL,
      NULL,
      80.187424,
      ' 9- 3-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      15,
      ' 5- 8-1998',
      64.618268,
      2,
      19,
      '11-22-1986',
      0,
      29.534268,
      ' 5- 5-1977',
      10.989987,
      NULL,
      7.276421,
      NULL,
      ' 3-26-1993',
      7,
      NULL,
      41,
      ' 0- 7-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


