set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9300926';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0442',
      '34401141',
      '22232301',
      NULL,
      NULL,
      '31410012',
      '04304130',
      '10431124',
      '32214124',
      '30302414',
      NULL,
      '00404212',
      '10240220',
      '03344410',
      '01130241',
      '40210444',
      '43143040',
      '32441140',
      '10441121',
      NULL,
      NULL,
      '21240312',
      '23104100',
      '31331012',
      '13242201',
      NULL,
      '21104133',
      '32414342',
      '23334031',
      '23041133',
      '13204220',
      '32001341',
      '10212334',
      '13100312',
      NULL,
      NULL,
      NULL,
      '02233121',
      '13041222',
      '13040241',
      '42034324',
      '22130223',
      '31404303',
      '44043042',
      '14024224',
      NULL,
      '30',
      NULL,
      NULL,
      '1440134',
      1.502427,
      0.433000,
      2,
      NULL,
      '304224',
      5,
      NULL,
      ' 8-20-1980',
      30.251909,
      NULL,
      NULL,
      NULL,
      10.924554,
      5,
      9.757259,
      6,
      5.951051,
      6,
      1.781599,
      4.809136,
      12,
      8,
      7.188862,
      3,
      NULL,
      6.298457,
      2,
      1,
      3.870722,
      3.344602,
      32,
      9.991497,
      1.454469,
      54.208881,
      70,
      17,
      95,
      NULL,
      NULL,
      ' 8- 6-1977',
      NULL,
      1.352242,
      22,
      15.741830,
      74,
      NULL,
      ' 6-14-2003',
      1,
      5,
      0.080116,
      NULL,
      0,
      1.531431,
      2.135500,
      3,
      1.796568,
      NULL,
      1,
      1.961782,
      0,
      0,
      0.565332,
      NULL,
      0,
      2,
      1.646799,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-11-1981',
      16.458433,
      NULL,
      53,
      6,
      30,
      2,
      ' 2-10-1975',
      NULL,
      1,
      82,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      13,
      0.363543,
      NULL,
      NULL,
      ' 9- 4-1977',
      NULL,
      23.013187,
      1,
      NULL,
      45,
      24,
      22.769521,
      90.594611,
      25.765976,
      19,
      88,
      9.040446,
      ' 4-24-1991',
      20.205078,
      20.858460,
      4,
      36,
      26,
      37.268513,
      10,
      ' 5-24-1976',
      NULL,
      7,
      NULL,
      8.091303,
      2.147471,
      NULL,
      7,
      23.842098,
      4,
      1.794944,
      15,
      1,
      6.714277,
      1,
      5,
      2,
      11,
      1,
      NULL,
      0,
      1.136406,
      NULL,
      1.632507,
      NULL,
      2,
      ' 4- 2-1978',
      45.849372,
      5,
      ' 0- 7-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-17-1984',
      NULL,
      NULL,
      ' 4-16-1980',
      45,
      60,
      ' 2- 0-1994',
      NULL,
      2,
      NULL,
      0,
      8.930254,
      ' 6-28-1986',
      NULL,
      2,
      23,
      '11-21-2001',
      37,
      11,
      NULL,
      ' 0- 5-2000',
      4,
      284,
      ' 0- 3-1994',
      4,
      85,
      0,
      15.059558,
      ' 4-28-1976',
      NULL,
      0,
      128,
      ' 7-24-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.836569);
commit;
end;
/


