set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9300926';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4322',
      '40313214',
      '04122432',
      '10033144',
      '22011102',
      '32311034',
      '11334003',
      '00043032',
      NULL,
      '34214143',
      '33034123',
      '21123232',
      '04023420',
      '42244404',
      '04230212',
      '14210044',
      '11344432',
      NULL,
      '12232234',
      '12300001',
      '11233231',
      '04113330',
      '22120221',
      '13444310',
      '23203111',
      '30022044',
      '43040330',
      '24332130',
      '10202022',
      '34120012',
      '22202021',
      '30330142',
      '34420300',
      NULL,
      '20222013',
      '22142120',
      '44424011',
      NULL,
      '42112043',
      NULL,
      NULL,
      '03010022',
      '30241420',
      '24241230',
      '41204013',
      '024',
      '13',
      NULL,
      NULL,
      '3233041',
      NULL,
      16.782104,
      3,
      NULL,
      '041401',
      1,
      '11-20-1981',
      ' 3-20-1999',
      72.746045,
      NULL,
      2.996470,
      0.472944,
      11,
      4,
      14.913340,
      8,
      4,
      9.461130,
      NULL,
      5.732764,
      NULL,
      11,
      2.766152,
      0,
      NULL,
      1.180980,
      NULL,
      5,
      7.996181,
      1.598870,
      22.718047,
      2,
      NULL,
      41,
      58,
      33,
      114,
      82.909982,
      87,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      15.604658,
      11.368370,
      ' 8- 0-1974',
      1,
      NULL,
      4,
      8,
      7,
      12.891376,
      6.007741,
      12,
      0,
      NULL,
      16,
      1.016517,
      0,
      10,
      0.578438,
      1,
      NULL,
      0,
      0.959776,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      22.120893,
      56.445038,
      1,
      NULL,
      1,
      1,
      58,
      3,
      1,
      50.391273,
      6,
      NULL,
      10.974864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      63.827064,
      19.797908,
      20.347615,
      NULL,
      55,
      62,
      10.209818,
      38.530673,
      50,
      ' 8-10-1996',
      NULL,
      NULL,
      11,
      53.880317,
      NULL,
      20,
      NULL,
      ' 3- 2-1978',
      18.217346,
      17,
      ' 0-25-1995',
      14.312713,
      13,
      5,
      16.451836,
      15,
      4.336029,
      0,
      12.085070,
      1.607100,
      41.750320,
      6,
      9.928417,
      11.858625,
      11,
      2.812428,
      3.809007,
      0,
      0,
      ' 9-25-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      ' 7-16-2000',
      9,
      7.767721,
      ' 0-27-1976',
      NULL,
      NULL,
      NULL,
      0,
      7,
      ' 0- 3-1979',
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      ' 9- 5-1999',
      NULL,
      10,
      NULL,
      ' 4- 9-1992',
      9.618074,
      386,
      ' 2-10-1986',
      5,
      123,
      4.144617,
      NULL,
      ' 5- 6-1981',
      45.278634,
      1.680262,
      39.405628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


