set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9300926';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      '0',
      NULL,
      '1',
      '4',
      '4',
      '3',
      '4',
      NULL,
      '4',
      '3',
      NULL,
      '4',
      '0',
      '2',
      '0',
      '3',
      '1',
      '0',
      '3',
      '0',
      NULL,
      '2',
      '',
      '3',
      '',
      '3',
      '4',
      '2',
      '2',
      '4',
      '',
      '',
      '3',
      '4',
      '3',
      '0',
      NULL,
      '2',
      '2',
      '0',
      '0',
      '1',
      '1',
      '422',
      '23021122',
      NULL,
      67.360486,
      '0403141',
      3.649265,
      148.155588,
      NULL,
      NULL,
      '044430',
      0,
      ' 3-25-2001',
      ' 1- 3-1992',
      271.071675,
      38.447120,
      8,
      1,
      13.039574,
      NULL,
      9.671109,
      NULL,
      8,
      NULL,
      4.117550,
      NULL,
      21,
      5,
      9,
      0,
      2.006116,
      3,
      NULL,
      2.605872,
      NULL,
      8,
      57.420179,
      NULL,
      0,
      29.323422,
      6,
      16,
      NULL,
      0,
      31,
      ' 3-22-1992',
      12.847509,
      3.718176,
      17,
      11.346224,
      137,
      120.596128,
      ' 6- 9-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      44,
      65,
      0.684464,
      NULL,
      1,
      ' 2-19-1998',
      NULL,
      1,
      NULL,
      NULL,
      4.939262,
      NULL,
      NULL,
      0.864970,
      10,
      NULL,
      NULL,
      NULL,
      ' 8-28-1995',
      32,
      60,
      NULL,
      33,
      NULL,
      64.140533,
      36.067778,
      64,
      38.783273,
      50.381046,
      48,
      50.807978,
      ' 3-29-1974',
      7,
      15,
      NULL,
      17.396853,
      39.135503,
      43,
      9,
      ' 1-13-2003',
      1,
      1,
      ' 1-29-1980',
      NULL,
      8.266534,
      1,
      3.567951,
      14,
      0,
      0.008168,
      1.469560,
      1.932309,
      19.271134,
      0.118556,
      1.865986,
      0.032130,
      9,
      4,
      NULL,
      8.065322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-10-1977',
      6,
      1,
      ' 1-15-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      16.292122,
      NULL,
      7.163777,
      10.482750,
      10,
      ' 7- 7-1974',
      NULL,
      NULL,
      NULL,
      1.371302,
      139.923151,
      0,
      15,
      NULL,
      12,
      1.026396,
      37,
      ' 4-26-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


