set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9300926';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      '3',
      '2',
      '3',
      '4',
      '4',
      '4',
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      '4',
      '2',
      '3',
      '2',
      '3',
      '4',
      NULL,
      '4',
      '',
      '3',
      '',
      '1',
      '4',
      '3',
      '0',
      '3',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      '3',
      '1',
      '3',
      '0',
      '0',
      '3',
      '410',
      '21330222',
      62.891511,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3.920672,
      ' 4-29-1987',
      NULL,
      NULL,
      2.077592,
      2.850766,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      9.717079,
      4.596380,
      3,
      2,
      3.895168,
      3,
      3.368453,
      NULL,
      0,
      10.254903,
      2.400613,
      8,
      7.034703,
      1,
      60.359107,
      1.112040,
      1.323622,
      36.086657,
      37,
      30,
      NULL,
      6.111380,
      110,
      '11-21-1984',
      8,
      NULL,
      7,
      6,
      84.092267,
      29,
      ' 1- 1-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      42,
      NULL,
      19.834964,
      26.726245,
      NULL,
      NULL,
      1,
      0,
      61,
      NULL,
      1.191208,
      60,
      2,
      5,
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      10.422325,
      82,
      44.484587,
      44.469196,
      NULL,
      27.245615,
      4.422456,
      72.357307,
      64,
      NULL,
      70.051714,
      12,
      ' 7-13-1992',
      15.253677,
      NULL,
      6,
      29.250953,
      42.815276,
      1.594561,
      1.426316,
      ' 9-23-1990',
      11,
      10,
      ' 7-22-1990',
      3,
      7.400264,
      3.833647,
      9.233314,
      11.545698,
      NULL,
      1.634771,
      1.723648,
      0.673341,
      NULL,
      1,
      1.380830,
      4.532216,
      NULL,
      0,
      3,
      2,
      NULL,
      ' 0- 1-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 0-1991',
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      ' 3-19-2003',
      6,
      10.325888,
      7,
      ' 7-18-1982',
      NULL,
      NULL,
      NULL,
      1.776071,
      NULL,
      NULL,
      104.306748,
      NULL,
      5.959693,
      1.086788,
      73.315872,
      ' 5- 1-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


