set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8927771';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3040',
      '43341021',
      '34132410',
      '02340411',
      NULL,
      NULL,
      '00220320',
      '01414312',
      '04022111',
      '30404304',
      NULL,
      '30303421',
      '13300300',
      NULL,
      '22332233',
      '20300024',
      '00020432',
      '04023012',
      '22214141',
      NULL,
      '04103133',
      '22121403',
      '44043034',
      '14301244',
      '34414041',
      NULL,
      '30412243',
      '21312444',
      '21241412',
      '02304323',
      '21243232',
      '21102200',
      NULL,
      NULL,
      NULL,
      '22343433',
      '42440431',
      NULL,
      '31311031',
      '24341131',
      '04312141',
      '41010410',
      '40023343',
      '02443222',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '0034242',
      3,
      0.052897,
      2,
      NULL,
      '431210',
      NULL,
      '10-29-1978',
      NULL,
      NULL,
      NULL,
      30,
      3.879089,
      11.913625,
      NULL,
      63.084604,
      7,
      29.804405,
      1.624203,
      NULL,
      13.332088,
      NULL,
      12.258561,
      1.139095,
      18.222271,
      2,
      NULL,
      64.691778,
      NULL,
      44,
      10.354864,
      NULL,
      3.010900,
      NULL,
      55,
      2,
      94,
      NULL,
      249,
      169.088767,
      ' 9-27-1983',
      64.403743,
      NULL,
      6,
      NULL,
      96,
      NULL,
      ' 1- 7-1992',
      0,
      NULL,
      NULL,
      3.080947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.039840,
      4,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-10-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      144,
      NULL,
      135,
      99.186993,
      119.782031,
      85,
      NULL,
      NULL,
      53,
      NULL,
      42,
      88.790463,
      ' 0- 5-1984',
      NULL,
      5,
      NULL,
      76.092549,
      NULL,
      0.419900,
      NULL,
      ' 2-28-2001',
      11,
      22,
      NULL,
      0,
      15.271147,
      12,
      2.896433,
      5.733430,
      NULL,
      NULL,
      NULL,
      NULL,
      111,
      NULL,
      24,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-24-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.938640,
      36.613127,
      35,
      NULL,
      0.769653,
      NULL,
      NULL,
      NULL,
      16,
      12.418165,
      11,
      ' 2- 4-1976',
      NULL,
      1,
      29,
      ' 8-23-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      74.862543,
      147.540246,
      NULL,
      NULL,
      8,
      26,
      20.500282,
      9,
      8,
      11.040308,
      NULL,
      NULL,
      4.597439,
      76.691430,
      3.133155,
      NULL,
      64,
      0,
      2.763218,
      NULL,
      NULL,
      1.395552,
      167,
      NULL,
      10,
      NULL,
      0,
      NULL,
      0.692035,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0.440283,
      NULL,
      0.835495,
      NULL,
      4,
      NULL,
      1,
      1,
      NULL,
      26.044796,
      10.041501,
      10.846850,
      NULL,
      NULL,
      11,
      NULL,
      15,
      1.007193,
      1.107861,
      NULL,
      0.161637,
      0.740991,
      1.447540,
      0,
      NULL,
      NULL,
      NULL,
      ' 5-27-1996',
      ' 7- 2-1990',
      '11-11-1975',
      NULL,
      ' 4-16-1989',
      NULL);
commit;
end;
/


