set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9693915';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3330',
      '34140442',
      '42243444',
      '31313030',
      '12331101',
      '12311131',
      NULL,
      '10422433',
      '11442223',
      '34322112',
      '31042204',
      '40320403',
      '12423233',
      '40403124',
      '21113221',
      NULL,
      '13412312',
      '40202022',
      '42010231',
      '23420141',
      '30033433',
      '01240434',
      '32042032',
      '41300222',
      '03230144',
      NULL,
      '21314021',
      '40242013',
      '33211012',
      '03230124',
      '01311000',
      '01403411',
      '11100404',
      '10223320',
      NULL,
      '14110030',
      '44044100',
      '24143200',
      NULL,
      '23141313',
      '13210013',
      NULL,
      '14244213',
      NULL,
      NULL,
      '200',
      '04',
      24.247840,
      17,
      '4242430',
      0,
      NULL,
      2,
      NULL,
      '422203',
      2,
      NULL,
      ' 0- 5-1980',
      39,
      84,
      8.181212,
      5.625424,
      23,
      NULL,
      48,
      4,
      12.634725,
      4.231700,
      23.794088,
      15,
      28.816454,
      NULL,
      26.588080,
      13.971725,
      8,
      3,
      NULL,
      8.392992,
      30.329633,
      14,
      88,
      9,
      1,
      NULL,
      34.561614,
      NULL,
      122,
      53.201002,
      28.460868,
      NULL,
      39,
      6.583006,
      8.685777,
      9.137544,
      109.495675,
      124.424189,
      ' 0- 3-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      98,
      12,
      13.512046,
      4.223640,
      NULL,
      8.941380,
      NULL,
      NULL,
      1,
      6,
      0,
      1.500671,
      78,
      1,
      2,
      73,
      NULL,
      NULL,
      NULL,
      ' 4-22-1987',
      21.578316,
      NULL,
      58,
      74,
      52,
      58.196845,
      NULL,
      34.824009,
      NULL,
      NULL,
      82,
      NULL,
      ' 8-14-1983',
      NULL,
      7.451395,
      4.976297,
      2.821301,
      11,
      60,
      7.870901,
      NULL,
      17,
      6,
      NULL,
      3,
      2,
      9,
      21.096468,
      0,
      5,
      2.361824,
      20,
      0,
      16.902706,
      5,
      0,
      14,
      19.926505,
      1.392632,
      1,
      3,
      3,
      ' 7-26-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      156,
      6.867560,
      '10-17-1998',
      NULL,
      NULL,
      NULL,
      22.715353,
      ' 3-15-2000',
      25.763773,
      ' 0-13-1986',
      0,
      9,
      ' 7- 6-1984',
      103,
      1.346859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      9.973667,
      ' 8- 0-2000',
      25,
      14,
      0,
      ' 7-26-1981',
      0.979203,
      50.500416,
      ' 3-19-1998',
      NULL,
      22.628258,
      3,
      NULL,
      NULL,
      13,
      0,
      123.557136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


