set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303862';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '34112423',
      '02034421',
      '34341322',
      NULL,
      '22442322',
      '34230334',
      '04432140',
      '13414221',
      '32412200',
      '24123332',
      '11202202',
      NULL,
      '01434223',
      '23432430',
      NULL,
      '12441202',
      NULL,
      '14331211',
      '41330313',
      '13233423',
      '30134204',
      '24143102',
      '23240141',
      '22234400',
      '43434000',
      '02302041',
      '32204242',
      NULL,
      '02134300',
      NULL,
      '14234112',
      NULL,
      '30213031',
      '14213114',
      '34443030',
      '33044202',
      '31301104',
      NULL,
      NULL,
      NULL,
      '31411444',
      '10213032',
      NULL,
      '040',
      NULL,
      NULL,
      NULL,
      NULL,
      1.988545,
      1.983862,
      NULL,
      NULL,
      '144222',
      NULL,
      ' 1-16-1982',
      ' 9-18-1988',
      NULL,
      NULL,
      7.078245,
      7,
      12,
      NULL,
      NULL,
      8.007477,
      1,
      1,
      58,
      0.515027,
      22,
      NULL,
      NULL,
      12.368755,
      NULL,
      11.122352,
      11.447544,
      18.764464,
      31,
      14.940195,
      10,
      18,
      0,
      80,
      89.709034,
      102,
      136,
      93,
      133,
      '11-14-1975',
      49.698003,
      18,
      NULL,
      NULL,
      NULL,
      104,
      ' 0-22-1991',
      NULL,
      NULL,
      3.684850,
      1,
      1,
      1.585160,
      0.663068,
      0,
      NULL,
      1.492310,
      0,
      1,
      1,
      0.046847,
      0,
      1.272653,
      0.965047,
      0.728563,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      26,
      NULL,
      10,
      0,
      3,
      ' 3-15-1991',
      0,
      1,
      79.623139,
      NULL,
      0,
      95,
      0,
      0.397329,
      53.811134,
      0.347737,
      3,
      151,
      ' 3- 5-1999',
      6.536050,
      29,
      73,
      77.976117,
      83.056127,
      49.477729,
      NULL,
      35,
      102,
      46.974204,
      85.569061,
      57.436745,
      NULL,
      18,
      NULL,
      15.613668,
      39,
      NULL,
      106.453187,
      NULL,
      ' 6- 8-1997',
      10.843026,
      2.880284,
      ' 5-16-1982',
      NULL,
      0.587571,
      NULL,
      3,
      23,
      7.393225,
      0,
      14.341938,
      0.784614,
      8,
      0.580998,
      0,
      NULL,
      16.696972,
      NULL,
      0,
      4,
      1.345440,
      ' 1-16-1995',
      1.275523,
      2,
      0.002827,
      ' 2- 0-1977',
      234,
      4.550549,
      '11-25-1986',
      NULL,
      NULL,
      NULL,
      25.037159,
      ' 4-21-1985',
      42,
      ' 5- 6-2000',
      7,
      6.992816,
      ' 2- 2-1996',
      NULL,
      12,
      ' 4-12-1992',
      17.220965,
      NULL,
      ' 6- 1-1997',
      9,
      NULL,
      ' 2- 3-1995',
      NULL,
      NULL,
      18,
      ' 5-17-1993',
      50,
      1.822327,
      6.283398,
      ' 2-26-1988',
      0,
      NULL,
      ' 3-29-1997',
      11.741241,
      20,
      NULL,
      NULL,
      ' 1- 9-1989',
      39.309557,
      0,
      37,
      ' 8-19-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.033596);
commit;
end;
/


