set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9303862';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1110',
      '32310030',
      NULL,
      '13232223',
      '01140111',
      NULL,
      NULL,
      '21410403',
      '00243340',
      NULL,
      '21120140',
      '03110100',
      NULL,
      '24401311',
      '33021141',
      '41140212',
      '04331013',
      NULL,
      '41322400',
      '23101141',
      NULL,
      NULL,
      '11014001',
      NULL,
      '31303231',
      '13310233',
      '01030313',
      '21011332',
      '13334401',
      '41114420',
      '01313243',
      '04203441',
      '42221022',
      '12013333',
      '01304341',
      '23200332',
      NULL,
      '20023100',
      NULL,
      '10312204',
      NULL,
      '40124103',
      '44011023',
      '02132042',
      NULL,
      '000',
      '01',
      NULL,
      NULL,
      NULL,
      3.879581,
      1.430639,
      1,
      NULL,
      NULL,
      2.039794,
      ' 6- 8-1981',
      '10-18-1999',
      NULL,
      NULL,
      23.218988,
      1.709621,
      2,
      NULL,
      113,
      12,
      14,
      18,
      1.957490,
      1,
      0.902121,
      NULL,
      18,
      3.140895,
      7,
      4,
      84.240172,
      NULL,
      NULL,
      18,
      61.163239,
      NULL,
      0.715441,
      NULL,
      130.798539,
      113.971478,
      113.708500,
      195,
      0,
      ' 8-29-1994',
      4,
      NULL,
      20,
      17.127689,
      183,
      NULL,
      '11-15-1992',
      1.074317,
      0.994121,
      NULL,
      0,
      0.802128,
      0.165895,
      0,
      1.030766,
      0.998174,
      1,
      1.994842,
      0.884668,
      NULL,
      1,
      0,
      0,
      0.424326,
      0,
      0.726530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-23-1995',
      105.081637,
      15,
      NULL,
      3.338463,
      1.916317,
      NULL,
      ' 3-12-1985',
      1,
      0.864557,
      NULL,
      1,
      0,
      121.314162,
      1,
      0,
      70.194948,
      NULL,
      NULL,
      NULL,
      ' 6- 6-2001',
      7.253675,
      63.932866,
      13.392905,
      8.126346,
      32,
      60.987383,
      62,
      48,
      68.683409,
      54,
      NULL,
      59,
      ' 2-23-2001',
      1,
      1,
      20,
      NULL,
      NULL,
      148.099549,
      2,
      ' 5-18-1987',
      NULL,
      7.602966,
      NULL,
      2,
      1,
      6.791654,
      21.260819,
      23.541160,
      5.797207,
      0,
      22.639650,
      0.885146,
      NULL,
      3,
      7,
      23,
      19.607167,
      2.376369,
      NULL,
      0,
      0,
      '11-23-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      88.189062,
      4.429423,
      NULL,
      NULL,
      NULL,
      NULL,
      56,
      ' 0- 1-1997',
      NULL,
      ' 8- 0-1989',
      16.169217,
      NULL,
      NULL,
      NULL,
      73.868378,
      '10- 4-2000',
      4,
      12.525426,
      ' 1- 1-1974',
      NULL,
      NULL,
      NULL,
      0,
      1,
      23,
      ' 7-21-1982',
      NULL,
      61.552231,
      29,
      ' 6-21-1978',
      NULL,
      30,
      NULL,
      14.366935,
      NULL,
      3.043666,
      28.839378,
      ' 1-10-2003',
      24,
      1,
      22.823016,
      ' 7-11-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


