set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9432828';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2412',
      NULL,
      '11310333',
      '01422443',
      '01021200',
      '00133443',
      '40441431',
      '42043041',
      '23231203',
      '33422343',
      '13322223',
      '11241320',
      '04331230',
      '40433131',
      '42331100',
      '10013442',
      NULL,
      '40411441',
      '40004440',
      NULL,
      '31210111',
      '34301433',
      '24400400',
      '32432310',
      '42033341',
      NULL,
      '14242212',
      NULL,
      '20112441',
      '20014022',
      '11410102',
      '30212020',
      '41344304',
      '10102143',
      '21140340',
      '43024041',
      '03301223',
      '22241134',
      '40202444',
      '20122201',
      '11302222',
      '21413133',
      '01332211',
      '41401310',
      '40311122',
      '201',
      NULL,
      12,
      12,
      '2224204',
      NULL,
      0,
      0,
      NULL,
      '440214',
      1,
      ' 7-23-2003',
      ' 6-10-1999',
      NULL,
      86,
      NULL,
      NULL,
      13,
      6.699776,
      77,
      1.830941,
      15.289228,
      5,
      20,
      27,
      NULL,
      23,
      23.100812,
      9,
      30,
      NULL,
      43.710214,
      21.723503,
      2.482442,
      NULL,
      NULL,
      12,
      1.320234,
      26,
      NULL,
      77,
      13,
      69,
      NULL,
      ' 3-16-1996',
      66.191532,
      NULL,
      9,
      32.913276,
      NULL,
      244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66.780731,
      23,
      2.545595,
      15,
      NULL,
      9.806061,
      '11-24-2001',
      1,
      1,
      23.103457,
      1.797834,
      1.815504,
      62.534916,
      1,
      0,
      63,
      NULL,
      NULL,
      NULL,
      NULL,
      19.655569,
      68,
      63.586436,
      NULL,
      24.024094,
      NULL,
      5.332281,
      NULL,
      NULL,
      66.038432,
      91,
      14,
      ' 3-21-1985',
      8,
      8.959864,
      27.223861,
      61.456981,
      31,
      NULL,
      12,
      ' 2-24-1997',
      20,
      3,
      NULL,
      16,
      22,
      21.840103,
      NULL,
      17,
      NULL,
      0.966983,
      23.553933,
      0,
      32.278675,
      0,
      1.567249,
      NULL,
      28.437715,
      1,
      0,
      1,
      0.075446,
      ' 6- 7-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-17-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      ' 3- 4-2003',
      2.648998,
      12.267875,
      ' 6-19-1983',
      NULL,
      105.932904,
      ' 4-11-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      10.443736,
      NULL,
      NULL,
      36.179126,
      5,
      ' 7- 1-1986',
      0.913051,
      NULL,
      ' 3-22-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


