set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8228030';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3000',
      '42042114',
      NULL,
      '12402114',
      '34101013',
      NULL,
      '21143021',
      '33023034',
      NULL,
      '40312324',
      '32341420',
      '10301142',
      '22210334',
      '14300222',
      '24020140',
      NULL,
      '41103310',
      '40442244',
      '40431421',
      '01144210',
      '02243434',
      NULL,
      '44342210',
      '41222202',
      '41421222',
      '01312101',
      NULL,
      NULL,
      '33434431',
      '24322444',
      '00144124',
      '12312423',
      '30140330',
      '40441411',
      '42343242',
      '24321224',
      '04032424',
      NULL,
      '03323201',
      NULL,
      NULL,
      '31022431',
      '12120010',
      '42101430',
      '04021223',
      '434',
      '21',
      NULL,
      NULL,
      '1302433',
      NULL,
      0.123489,
      NULL,
      NULL,
      '324300',
      4,
      ' 1-26-1993',
      NULL,
      97,
      NULL,
      29,
      11,
      21,
      3,
      60.495467,
      1,
      13,
      NULL,
      19,
      17,
      16,
      NULL,
      NULL,
      16,
      NULL,
      11,
      NULL,
      0.579329,
      11,
      20,
      31,
      4,
      0.984066,
      29,
      43.618079,
      42,
      163.835914,
      NULL,
      71.653577,
      ' 3-27-1989',
      NULL,
      28.307918,
      NULL,
      6.369339,
      120,
      181,
      '10- 8-1981',
      1,
      1.486037,
      7,
      NULL,
      1,
      3,
      5,
      1.687240,
      0.469386,
      1.632803,
      3,
      NULL,
      0,
      1,
      0,
      1.074685,
      3.381820,
      1.372387,
      1.439575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 2-1983',
      0,
      5,
      11,
      NULL,
      16,
      6.147336,
      ' 2- 4-1983',
      3.213812,
      0.968924,
      175.281001,
      0,
      1,
      63.023923,
      3.574199,
      0.316704,
      23.382784,
      0.669242,
      0.138860,
      167,
      ' 3-17-1981',
      77.786258,
      48.668240,
      26.064560,
      90,
      30,
      NULL,
      29,
      61,
      9,
      NULL,
      91,
      20.936804,
      ' 7- 8-1978',
      14,
      7,
      16.608021,
      49,
      65,
      59,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-19-1989',
      8,
      0.559951,
      5.646559,
      11.921288,
      NULL,
      0,
      1,
      NULL,
      1,
      3,
      2,
      NULL,
      10,
      13.381270,
      1,
      5.709431,
      NULL,
      0,
      '11-27-1998',
      4,
      1,
      1,
      ' 2-12-1988',
      17.893093,
      16.973630,
      NULL,
      NULL,
      NULL,
      NULL,
      20.547272,
      NULL,
      47.469277,
      NULL,
      NULL,
      9,
      ' 9-10-1989',
      28.238452,
      94.858425,
      NULL,
      13,
      NULL,
      ' 4-29-1998',
      1,
      5,
      NULL,
      3,
      3,
      1,
      ' 1- 4-1975',
      18.140581,
      36,
      10.841510,
      '11-21-1996',
      0,
      170.651060,
      ' 1- 9-1999',
      10.332190,
      26.094334,
      1,
      28.392867,
      NULL,
      42.555276,
      0,
      56.340825,
      ' 9- 7-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.671961);
commit;
end;
/


