set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8228030';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4211',
      '23302243',
      '00204340',
      '33022324',
      '30024334',
      '23440332',
      '21202400',
      '33413341',
      NULL,
      '23412334',
      '33123033',
      '12230412',
      '44331202',
      '32301213',
      NULL,
      NULL,
      NULL,
      '33243424',
      NULL,
      NULL,
      '24222434',
      '33001300',
      '34014030',
      NULL,
      '11011323',
      '04440414',
      '11043342',
      '21022342',
      NULL,
      '23232003',
      NULL,
      '34003122',
      '11201000',
      '01333104',
      '41303030',
      '23204324',
      '41210440',
      '14243041',
      '21402220',
      '32044230',
      '10141211',
      '21124421',
      '24340404',
      '30430040',
      '04444303',
      NULL,
      '34',
      NULL,
      NULL,
      '1030042',
      1,
      10.601158,
      NULL,
      NULL,
      '303142',
      0.682945,
      NULL,
      ' 9-10-1974',
      23,
      NULL,
      18.596263,
      NULL,
      7,
      NULL,
      NULL,
      11.196577,
      1,
      12.948584,
      19.516304,
      15,
      11,
      6,
      NULL,
      0.817781,
      27.103706,
      23.963366,
      51.736462,
      5,
      28.972764,
      NULL,
      NULL,
      19.470441,
      1,
      87,
      175,
      50,
      149,
      29,
      NULL,
      ' 9-21-2002',
      65.338603,
      24,
      NULL,
      13.816357,
      56,
      119,
      '10-29-1995',
      1.909770,
      1,
      4.725805,
      0.362349,
      2.007403,
      2,
      7,
      NULL,
      NULL,
      1,
      6,
      0.508032,
      1.293668,
      5.718989,
      1.007812,
      0.332168,
      1,
      0.156704,
      0,
      1.113126,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-14-1994',
      NULL,
      18.548782,
      NULL,
      14.269346,
      NULL,
      4,
      NULL,
      1.280397,
      2.536956,
      62.046310,
      1.806189,
      NULL,
      91,
      NULL,
      1,
      66.224918,
      NULL,
      NULL,
      NULL,
      NULL,
      91.714705,
      27.033479,
      42.621831,
      68,
      56.605335,
      52.002136,
      93,
      48.895494,
      39,
      26.515223,
      73,
      78.470772,
      NULL,
      3.484073,
      14.093621,
      9.209105,
      33.234605,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      2.799512,
      ' 5-15-2002',
      1.963913,
      9,
      NULL,
      21.223567,
      13.994074,
      11,
      1,
      9.847300,
      1,
      27,
      1,
      0.404229,
      14.424659,
      8.620663,
      0,
      1.745354,
      4.372668,
      0.708921,
      ' 4- 4-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      193.599589,
      4.718734,
      ' 2-18-1994',
      NULL,
      NULL,
      NULL,
      5.297019,
      ' 7- 6-1992',
      24,
      ' 7-22-1985',
      6.960007,
      14.014621,
      NULL,
      13,
      9.991837,
      NULL,
      0.153484,
      0,
      '11- 6-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 1-23-1986',
      NULL,
      49,
      32,
      NULL,
      0,
      170,
      ' 1-29-1992',
      NULL,
      39,
      8,
      59.155448,
      '10-15-1999',
      64,
      0.650609,
      68,
      ' 7-15-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


