set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8228030';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      NULL,
      '0',
      '0',
      NULL,
      '3',
      '4',
      '4',
      '4',
      '2',
      '4',
      '4',
      NULL,
      '1',
      '0',
      '1',
      NULL,
      '2',
      '0',
      '0',
      NULL,
      '3',
      '1',
      '',
      '2',
      '',
      NULL,
      NULL,
      '4',
      '4',
      '4',
      NULL,
      '',
      NULL,
      '1',
      '2',
      '3',
      '2',
      '3',
      '2',
      '4',
      '1',
      '1',
      '0',
      '120',
      '04020433',
      NULL,
      NULL,
      NULL,
      NULL,
      209,
      1,
      NULL,
      '430104',
      4.035574,
      '11- 5-1999',
      ' 0-11-1987',
      65.672688,
      51.769641,
      21,
      14.295698,
      NULL,
      10.947424,
      67.015743,
      7,
      4,
      NULL,
      10,
      20.923774,
      9,
      19.360293,
      28,
      NULL,
      36.743567,
      6.188257,
      45,
      7.028219,
      36,
      NULL,
      11.501336,
      15,
      1,
      NULL,
      48,
      109.093403,
      175.865644,
      NULL,
      74.117006,
      '11-20-1988',
      NULL,
      27.140905,
      17,
      8.422268,
      141.117505,
      NULL,
      ' 7-24-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57,
      31,
      9,
      25,
      39,
      NULL,
      ' 5-23-1979',
      1,
      0,
      18,
      0,
      NULL,
      80.566362,
      1.259135,
      0.986717,
      0,
      NULL,
      NULL,
      NULL,
      ' 6-28-1987',
      29,
      NULL,
      79.785413,
      61.077617,
      56.340793,
      13,
      96.810528,
      91,
      64,
      75,
      43,
      NULL,
      NULL,
      NULL,
      1,
      8.039228,
      34,
      NULL,
      NULL,
      10,
      ' 7-12-1998',
      31,
      19,
      NULL,
      1.589901,
      NULL,
      1,
      4.219952,
      9.446028,
      NULL,
      1,
      16,
      1,
      30,
      0,
      1.906026,
      10,
      23.506890,
      2.570725,
      1,
      NULL,
      0,
      ' 8-12-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      82.686680,
      5.552980,
      ' 5-12-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.648505,
      3,
      ' 9-17-1980',
      131,
      8,
      ' 1- 8-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      11.025359,
      ' 6-13-1984',
      64.011196,
      NULL,
      27,
      ' 4- 5-1995',
      1.003733,
      30.156990,
      ' 6-19-1989',
      12.050329,
      3,
      2.255308,
      14,
      '11-17-2002',
      30,
      1.621949,
      12.850516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


